/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.core.format.command;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import net.sf.microlog.core.Level;
import net.sf.microlog.core.format.command.FormatCommandInterface;

public class DateFormatCommand
implements FormatCommandInterface {
    public static int USER_FORMAT = 0;
    public static final int ABSOLUTE_FORMAT = 1;
    public static final int DATE_FORMAT = 2;
    public static final int ISO_8601_FORMAT = 3;
    public static final String ABSOLUTE_FORMAT_STRING = "ABSOLUTE";
    public static final String DATE_FORMAT_STRING = "DATE";
    public static final String ISO_8601_FORMAT_STRING = "ISO8601";
    static final String[] MONTH_ARRAY = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
    private static Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    int format = 1;

    public String execute(String clientID, String name, long time, Level level, Object message, Throwable throwable) {
        String dateString = "";
        long currentTime = System.currentTimeMillis();
        switch (this.format) {
            case 1: {
                dateString = this.toAbsoluteFormat(currentTime);
                break;
            }
            case 2: {
                dateString = this.toDateFormat(currentTime);
                break;
            }
            case 3: {
                dateString = this.toISO8601Format(currentTime);
                break;
            }
            default: {
                System.err.println("Unrecognized format, using default format.");
                dateString = this.toAbsoluteFormat(System.currentTimeMillis());
            }
        }
        return dateString;
    }

    public void init(String initString) {
        if (initString.equals(ABSOLUTE_FORMAT_STRING)) {
            this.format = 1;
        } else if (initString.equals(DATE_FORMAT_STRING)) {
            this.format = 2;
        } else if (initString.equals(ISO_8601_FORMAT_STRING)) {
            this.format = 3;
        }
    }

    String toAbsoluteFormat(long time) {
        calendar.setTime(new Date(time));
        long hours = calendar.get(11);
        StringBuffer buffer = new StringBuffer();
        if (hours < 10L) {
            buffer.append('0');
        }
        buffer.append(hours);
        buffer.append(':');
        long minutes = calendar.get(12);
        if (minutes < 10L) {
            buffer.append('0');
        }
        buffer.append(minutes);
        buffer.append(':');
        long seconds = calendar.get(13);
        if (seconds < 10L) {
            buffer.append('0');
        }
        buffer.append(seconds);
        buffer.append(',');
        long milliseconds = calendar.get(14);
        if (milliseconds < 10L) {
            buffer.append('0');
        }
        buffer.append(milliseconds);
        return buffer.toString();
    }

    String toDateFormat(long time) {
        calendar.setTime(new Date(time));
        StringBuffer buffer = new StringBuffer();
        int day = calendar.get(5);
        if (day < 10) {
            buffer.append('0');
        }
        buffer.append(day);
        buffer.append(' ');
        int month = calendar.get(2);
        buffer.append(MONTH_ARRAY[month]);
        buffer.append(' ');
        int year = calendar.get(1);
        buffer.append(year);
        buffer.append(' ');
        String absoluteTimeString = this.toAbsoluteFormat(time);
        buffer.append(absoluteTimeString);
        return buffer.toString();
    }

    String toISO8601Format(long time) {
        calendar.setTime(new Date(time));
        StringBuffer buffer = new StringBuffer();
        int year = calendar.get(1);
        buffer.append(year);
        buffer.append('-');
        int month = calendar.get(2) + 1;
        if (month < 10) {
            buffer.append('0');
        }
        buffer.append(month);
        buffer.append('-');
        int day = calendar.get(5);
        if (day < 10) {
            buffer.append('0');
        }
        buffer.append(day);
        buffer.append(' ');
        String absoluteTimeString = this.toAbsoluteFormat(time);
        buffer.append(absoluteTimeString);
        return buffer.toString();
    }
}

