/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.core;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import net.sf.microlog.core.Appender;
import net.sf.microlog.core.DefaultLoggerRepository;
import net.sf.microlog.core.Level;
import net.sf.microlog.core.StopWatch;
import net.sf.microlog.core.appender.ConsoleAppender;
import net.sf.microlog.core.format.PatternFormatter;

public final class Logger {
    public static final Level DEFAULT_LOG_LEVEL = Level.DEBUG;
    private String clientID;
    private String name;
    private Level level;
    private static final StopWatch stopWatch = new StopWatch();
    private static final Vector appenderList = new Vector(4);
    private static boolean firstLogEvent = true;

    Logger(String name) {
        this.name = name;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) throws IllegalArgumentException {
        if (level == null) {
            throw new IllegalArgumentException("The level must not be null.");
        }
        this.level = level;
    }

    public Level getEffectiveLevel() {
        Level effectiveLevel = this.level;
        if (effectiveLevel == null && !this.name.equals("")) {
            effectiveLevel = DefaultLoggerRepository.getInstance().getEffectiveLevel(this);
        }
        return effectiveLevel;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public String getName() {
        return this.name;
    }

    public void addAppender(Appender appender) throws IllegalArgumentException {
        if (appender == null) {
            throw new IllegalArgumentException("Appender not allowed to be null");
        }
        if (!appenderList.contains(appender)) {
            appenderList.addElement(appender);
        }
    }

    public void removeAppender(Appender appender) throws IllegalArgumentException {
        if (appender == null) {
            throw new IllegalArgumentException("The appender must not be null.");
        }
        if (appender.isLogOpen()) {
            try {
                appender.close();
            }
            catch (IOException e) {
                System.err.println("Failed to close appender. " + e);
            }
        }
        appenderList.removeElement(appender);
    }

    public void removeAllAppenders() {
        Enumeration enumeration = appenderList.elements();
        while (enumeration.hasMoreElements()) {
            Appender appender = (Appender)enumeration.nextElement();
            if (!appender.isLogOpen()) continue;
            try {
                appender.close();
            }
            catch (IOException e) {
                System.err.println("Failed to close appender. " + e);
            }
        }
        appenderList.removeAllElements();
    }

    public int getNumberOfAppenders() {
        return appenderList.size();
    }

    public Appender getAppender(int index) {
        return (Appender)appenderList.elementAt(index);
    }

    public void log(Level level, Object message) throws IllegalArgumentException {
        this.log(level, message, null);
    }

    public void log(Level level, Object message, Throwable t) throws IllegalArgumentException {
        if (level == null) {
            throw new IllegalArgumentException("The level must not be null.");
        }
        if (this.getEffectiveLevel().levelValue <= level.levelValue) {
            int nofAppenders = appenderList.size();
            if (firstLogEvent) {
                if (nofAppenders == 0) {
                    System.err.println("Warning! No appender is set, using ConsoleAppender with PatternFormatter");
                    ConsoleAppender appender = new ConsoleAppender();
                    appender.setFormatter(new PatternFormatter());
                    this.addAppender(appender);
                }
                try {
                    this.open();
                }
                catch (IOException e) {
                    System.err.println("Failed to open the log. " + e);
                }
                stopWatch.start();
                firstLogEvent = false;
            }
            for (int index = 0; index < nofAppenders; ++index) {
                Appender appender = (Appender)appenderList.elementAt(index);
                appender.doLog(this.clientID, this.name, stopWatch.getCurrentTime(), level, message, t);
            }
        }
    }

    public boolean isTraceEnabled() {
        Level effectiveLevel = this.getEffectiveLevel();
        return effectiveLevel.levelValue <= 0;
    }

    public void trace(Object message) {
        this.log(Level.TRACE, message, null);
    }

    public void trace(Object message, Throwable t) {
        this.log(Level.TRACE, message, t);
    }

    public boolean isDebugEnabled() {
        Level effectiveLevel = this.getEffectiveLevel();
        return effectiveLevel.levelValue <= 1;
    }

    public void debug(Object message) {
        this.log(Level.DEBUG, message, null);
    }

    public void debug(Object message, Throwable t) {
        this.log(Level.DEBUG, message, t);
    }

    public boolean isInfoEnabled() {
        Level effectiveLevel = this.getEffectiveLevel();
        return effectiveLevel.levelValue <= 2;
    }

    public void info(Object message) {
        this.log(Level.INFO, message, null);
    }

    public void info(Object message, Throwable t) {
        this.log(Level.INFO, message, t);
    }

    public boolean isWarnEnabled() {
        Level effectiveLevel = this.getEffectiveLevel();
        return effectiveLevel.levelValue <= 4;
    }

    public void warn(Object message) {
        this.log(Level.WARN, message, null);
    }

    public void warn(Object message, Throwable t) {
        this.log(Level.WARN, message, t);
    }

    public boolean isErrorEnabled() {
        Level effectiveLevel = this.getEffectiveLevel();
        return effectiveLevel.levelValue <= 8;
    }

    public void error(Object message) {
        this.log(Level.ERROR, message, null);
    }

    public void error(Object message, Throwable t) {
        this.log(Level.ERROR, message, t);
    }

    public boolean isFatalEnabled() {
        Level effectiveLevel = this.getEffectiveLevel();
        return effectiveLevel.levelValue <= 16;
    }

    public void fatal(Object message) {
        this.log(Level.FATAL, message, null);
    }

    public void fatal(Object message, Throwable t) {
        this.log(Level.FATAL, message, t);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append('[');
        int nofAppenders = appenderList.size();
        for (int index = 0; index < nofAppenders; ++index) {
            Appender appender = (Appender)appenderList.elementAt(index);
            stringBuffer.append(appender);
            stringBuffer.append(';');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    synchronized void resetLogger() {
        appenderList.removeAllElements();
        stopWatch.stop();
        stopWatch.reset();
        firstLogEvent = true;
    }

    void open() throws IOException {
        int nofAppenders = appenderList.size();
        for (int index = 0; index < nofAppenders; ++index) {
            Appender appender = (Appender)appenderList.elementAt(index);
            appender.open();
        }
    }

    void close() throws IOException {
        int nofAppenders = appenderList.size();
        for (int index = 0; index < nofAppenders; ++index) {
            Appender appender = (Appender)appenderList.elementAt(index);
            appender.close();
        }
        stopWatch.stop();
        firstLogEvent = true;
    }
}

