/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.core;

import java.util.Vector;

public class CyclicBuffer {
    public static final int DEFAULT_BUFFER_SIZE = 10;
    private int bufferSize;
    private Object[] buffer;
    int currentIndex = -1;
    int currentOldestIndex = -1;
    private int length;

    public CyclicBuffer() {
        this.bufferSize = 10;
        this.buffer = new Object[this.bufferSize];
    }

    public CyclicBuffer(int bufferSize) throws IllegalArgumentException {
        if (bufferSize < 0) {
            throw new IllegalArgumentException("Not allowed to resize to a negative size.");
        }
        this.bufferSize = bufferSize;
        this.buffer = new Object[bufferSize];
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int length() {
        return this.length;
    }

    public synchronized void resize(int newSize) throws IllegalArgumentException {
        if (newSize < 0) {
            throw new IllegalArgumentException("Not allowed to resize to a negative size.");
        }
        this.bufferSize = newSize;
        this.buffer = new Object[this.bufferSize];
    }

    public synchronized void add(Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException("You are not allowed to add an Object that is null.");
        }
        this.currentIndex = (this.currentIndex + 1) % this.buffer.length;
        this.buffer[this.currentIndex] = object;
        if (this.length < this.bufferSize) {
            ++this.length;
            this.currentOldestIndex = 0;
        } else {
            this.currentOldestIndex = (this.currentOldestIndex + 1) % this.buffer.length;
        }
    }

    public synchronized Object get() {
        Object object = null;
        if (this.length > 0) {
            object = this.buffer[this.currentOldestIndex];
            this.buffer[this.currentOldestIndex] = null;
            --this.length;
            if (this.length != 0) {
                this.currentOldestIndex = (this.currentOldestIndex + 1) % this.buffer.length;
            } else {
                this.currentOldestIndex = -1;
                this.currentIndex = -1;
            }
        }
        return object;
    }

    public synchronized void clear() {
        Object object = this.buffer[this.currentIndex];
        while (object != null) {
            this.buffer[this.currentIndex] = null;
            --this.currentIndex;
            --this.length;
            if (this.currentIndex == -1) {
                this.currentIndex = this.bufferSize - 1;
            }
            object = this.buffer[this.currentIndex];
        }
        this.currentIndex = -1;
        this.currentOldestIndex = -1;
    }

    public synchronized Vector getAsVector() {
        Vector<Object> vector = new Vector<Object>(this.length);
        for (int index = 0; index < this.length; ++index) {
            vector.addElement(this.buffer[index]);
        }
        return vector;
    }
}

