/*
 * Decompiled with CFR 0.152.
 */
package net.sf.michaelo.tomcat.realm.mapper;

import java.util.Arrays;
import java.util.Locale;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import net.sf.michaelo.tomcat.internal.org.apache.commons.lang3.StringUtils;
import net.sf.michaelo.tomcat.realm.mapper.SamAccountNameMapper;
import net.sf.michaelo.tomcat.realm.mapper.UsernameSearchMapper;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class SamAccountNameRfc2247Mapper
extends SamAccountNameMapper {
    protected static final Oid KRB5_NT_PRINCIPAL;
    private static final Oid[] SUPPORTED_STRING_NAME_TYPES;

    @Override
    public Oid[] getSupportedStringNameTypes() {
        return Arrays.copyOf(SUPPORTED_STRING_NAME_TYPES, SUPPORTED_STRING_NAME_TYPES.length);
    }

    @Override
    public boolean supportsGssName(GSSName gssName) {
        try {
            return gssName.getStringNameType().containedIn(SUPPORTED_STRING_NAME_TYPES);
        }
        catch (GSSException e) {
            return false;
        }
    }

    @Override
    public synchronized UsernameSearchMapper.MappedValues map(DirContext context, GSSName gssName) throws NamingException {
        if (!this.supportsGssName(gssName)) {
            throw new IllegalArgumentException("GSS name '" + gssName + "' is not supported");
        }
        String[] upnComponents = StringUtils.split(gssName.toString(), '@');
        String samAccountName = upnComponents[0];
        String realm = upnComponents[1];
        String searchBase = "";
        String[] realmComponents = StringUtils.split(realm, '.');
        NameParser parser = context.getNameParser("");
        Name searchBaseName = parser.parse("");
        for (int i = realmComponents.length - 1; i >= 0; --i) {
            searchBaseName.add("DC=" + realmComponents[i].toLowerCase(Locale.ROOT));
        }
        searchBase = searchBaseName.toString();
        return new SamAccountNameMapper.SamAccountNameMappedValues(searchBase, samAccountName);
    }

    static {
        try {
            KRB5_NT_PRINCIPAL = new Oid("1.2.840.113554.1.2.2.1");
        }
        catch (GSSException e) {
            throw new IllegalStateException("Failed to create OID for KRB5_NT_PRINCIPAL");
        }
        SUPPORTED_STRING_NAME_TYPES = new Oid[]{KRB5_NT_PRINCIPAL};
    }
}

