/*
 * Decompiled with CFR 0.152.
 */
package net.sf.michaelo.tomcat.realm;

import com.sun.security.jgss.AuthorizationDataEntry;
import com.sun.security.jgss.ExtendedGSSContext;
import com.sun.security.jgss.InquireType;
import java.security.Key;
import java.security.Principal;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KeyTab;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.sf.michaelo.tomcat.pac.GroupMembership;
import net.sf.michaelo.tomcat.pac.KerbValidationInfo;
import net.sf.michaelo.tomcat.pac.Pac;
import net.sf.michaelo.tomcat.pac.PrivateSunPacSignatureVerifier;
import net.sf.michaelo.tomcat.pac.asn1.AdIfRelevantAsn1Parser;
import net.sf.michaelo.tomcat.realm.ActiveDirectoryPrincipal;
import net.sf.michaelo.tomcat.realm.ActiveDirectoryRealmBase;
import net.sf.michaelo.tomcat.realm.Sid;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;

public class PacDataActiveDirectoryRealm
extends ActiveDirectoryRealmBase {
    private static final long USER_ACCOUNT_DISABLED = 1L;
    private static final long USER_NORMAL_ACCOUNT = 16L;
    private static final long USER_WORKSTATION_TRUST_ACCOUNT = 128L;
    protected String loginEntryName;
    protected boolean prependRoleFormat;
    protected boolean addAdditionalAttributes;

    public void setLoginEntryName(String loginEntryName) {
        this.loginEntryName = loginEntryName;
    }

    public void setPrependRoleFormat(boolean prependRoleFormat) {
        this.prependRoleFormat = prependRoleFormat;
    }

    public void setAddAdditionalAttributes(boolean addAdditionalAttributes) {
        this.addAdditionalAttributes = addAdditionalAttributes;
    }

    protected Principal getPrincipal(GSSName gssName, GSSCredential gssCredential, GSSContext gssContext) {
        if (gssName.isAnonymous()) {
            return new ActiveDirectoryPrincipal(gssName, Sid.ANONYMOUS_SID, gssCredential);
        }
        if (gssContext instanceof ExtendedGSSContext) {
            ExtendedGSSContext extGssContext = (ExtendedGSSContext)gssContext;
            AuthorizationDataEntry[] adEntries = null;
            try {
                adEntries = (AuthorizationDataEntry[])extGssContext.inquireSecContext(InquireType.KRB5_GET_AUTHZ_DATA);
            }
            catch (GSSException e) {
                this.logger.warn((Object)this.sm.getString("krb5AuthzDataRealmBase.inquireSecurityContextFailed"), (Throwable)e);
            }
            if (adEntries == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)this.sm.getString("krb5AuthzDataRealmBase.noDataProvided", new Object[]{gssName}));
                }
                return null;
            }
            Optional<Object> pacDataEntry = Optional.empty();
            try {
                pacDataEntry = Arrays.stream(adEntries).filter(adEntry -> adEntry.getType() == 1).map(adEntry -> AdIfRelevantAsn1Parser.parse(adEntry.getData())).flatMap(Collection::stream).filter(adEntry -> adEntry.getType() == 128).findFirst();
            }
            catch (Exception e) {
                String adEntriesStr = Arrays.stream(adEntries).map(adEntry -> adEntry.getType() + " " + Base64.getEncoder().encodeToString(adEntry.getData())).collect(Collectors.joining(",", "[", "]"));
                this.logger.warn((Object)this.sm.getString("pacDataActiveDirectoryRealm.incorrectlyEncodedData", new Object[]{adEntriesStr}), (Throwable)e);
                return null;
            }
            if (pacDataEntry.isPresent()) {
                byte[] pacData = ((AuthorizationDataEntry)pacDataEntry.get()).getData();
                Pac pac = null;
                try {
                    pac = new Pac(pacData, new PrivateSunPacSignatureVerifier());
                }
                catch (Exception e) {
                    this.logger.warn((Object)this.sm.getString("pacDataActiveDirectoryRealm.incorrectlyEncodedData", new Object[]{Base64.getEncoder().encodeToString(pacData)}), (Throwable)e);
                    return null;
                }
                Key[] keys = this.getKeys();
                try {
                    pac.verifySignature(keys);
                }
                catch (SignatureException e) {
                    this.logger.warn((Object)this.sm.getString("pacDataActiveDirectoryRealm.signatureVerificationFailed"), (Throwable)e);
                    return null;
                }
                KerbValidationInfo kerbValidationInfo = pac.getKerbValidationInfo();
                long userAccountControl = kerbValidationInfo.getUserAccountControl();
                if ((userAccountControl & 1L) != 0L) {
                    this.logger.warn((Object)this.sm.getString("activeDirectoryRealm.userFoundButDisabled", new Object[]{gssName}));
                    return null;
                }
                if ((userAccountControl & 0x10L) == 0L && (userAccountControl & 0x80L) == 0L) {
                    this.logger.warn((Object)this.sm.getString("activeDirectoryRealm.userFoundButNotSupported", new Object[]{gssName}));
                    return null;
                }
                long userId = kerbValidationInfo.getUserId();
                Sid sid = null;
                sid = userId == 0L ? kerbValidationInfo.getExtraSids().get(0).getSid() : kerbValidationInfo.getLogonDomainId().append(userId);
                HashSet<Sid> groups = new HashSet<Sid>();
                Sid primaryGroupSid = kerbValidationInfo.getLogonDomainId().append(kerbValidationInfo.getPrimaryGroupId());
                groups.add(primaryGroupSid);
                for (GroupMembership membership : kerbValidationInfo.getGroupIds()) {
                    groups.add(kerbValidationInfo.getLogonDomainId().append(membership.getRelativeId()));
                }
                if (kerbValidationInfo.getExtraSids() != null) {
                    long n = userId == 0L ? 1L : 0L;
                    groups.addAll(kerbValidationInfo.getExtraSids().stream().skip(n).map(extraSid -> extraSid.getSid()).collect(Collectors.toList()));
                }
                if (kerbValidationInfo.getResourceGroupDomainSid() != null) {
                    groups.addAll(kerbValidationInfo.getResourceGroupIds().stream().map(resourceGroupId -> kerbValidationInfo.getResourceGroupDomainSid().append(resourceGroupId.getRelativeId())).collect(Collectors.toList()));
                }
                HashMap<String, Object> additionalAttributesMap = null;
                if (this.addAdditionalAttributes) {
                    additionalAttributesMap = new HashMap<String, Object>();
                    additionalAttributesMap.put("sAMAccountName", kerbValidationInfo.getEffectiveName());
                    additionalAttributesMap.put("displayName", kerbValidationInfo.getFullName());
                    additionalAttributesMap.put("msDS-PrincipalName", kerbValidationInfo.getLogonDomainName() + "\\" + kerbValidationInfo.getEffectiveName());
                    if (pac.getUpnDnsInfo() != null) {
                        additionalAttributesMap.put("userPrincipalName", pac.getUpnDnsInfo().getUpn());
                    }
                }
                String roleFormatPrefix = this.prependRoleFormat ? "sid:" : "";
                List<String> roles = groups.stream().map(String::valueOf).map(group -> roleFormatPrefix + group).collect(Collectors.toList());
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)this.sm.getString("activeDirectoryRealm.foundRoles", new Object[]{roles.size(), gssName, roles}));
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)this.sm.getString("activeDirectoryRealm.foundRolesCount", new Object[]{roles.size(), gssName}));
                }
                return new ActiveDirectoryPrincipal(gssName, sid, roles, gssCredential, additionalAttributesMap);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)this.sm.getString("pacDataActiveDirectoryRealm.noDataProvided", new Object[]{gssName}));
            }
        } else {
            this.logger.error((Object)this.sm.getString("krb5AuthzDataRealmBase.incompatibleSecurityContextType"));
        }
        return null;
    }

    protected Key[] getKeys() {
        LoginContext lc = null;
        try {
            lc = new LoginContext(this.loginEntryName);
            lc.login();
            Subject subject = lc.getSubject();
            Set<KerberosPrincipal> principals = subject.getPrincipals(KerberosPrincipal.class);
            KerberosPrincipal principal = principals.iterator().next();
            Set<KeyTab> privateCredentials = subject.getPrivateCredentials(KeyTab.class);
            KeyTab keyTab = privateCredentials.iterator().next();
            Key[] keyArray = keyTab.getKeys(principal);
            return keyArray;
        }
        catch (LoginException e) {
            throw new IllegalStateException("Failed to load Kerberos keys for login entry '" + this.loginEntryName + "'", e);
        }
        finally {
            if (lc != null) {
                try {
                    lc.logout();
                }
                catch (LoginException loginException) {}
            }
        }
    }
}

