/*
 * Decompiled with CFR 0.152.
 */
package net.sf.michaelo.tomcat.realm;

import com.sun.security.jgss.AuthorizationDataEntry;
import com.sun.security.jgss.ExtendedGSSContext;
import com.sun.security.jgss.InquireType;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.Principal;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sf.michaelo.tomcat.realm.ActiveDirectoryRealmBase;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;

public class Krb5AuthzDataDumpingActiveDirectoryRealm
extends ActiveDirectoryRealmBase {
    private static final DateTimeFormatter TS_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss.SSS").withZone(ZoneId.systemDefault());
    private static final ConcurrentMap<String, Void> LOCKS = new ConcurrentHashMap<String, Void>();

    protected Principal getPrincipal(GSSName gssName, GSSCredential gssCredential, GSSContext gssContext) {
        if (gssContext instanceof ExtendedGSSContext) {
            ExtendedGSSContext extGssContext = (ExtendedGSSContext)gssContext;
            AuthorizationDataEntry[] adEntries = null;
            try {
                adEntries = (AuthorizationDataEntry[])extGssContext.inquireSecContext(InquireType.KRB5_GET_AUTHZ_DATA);
            }
            catch (GSSException e) {
                this.logger.warn((Object)this.sm.getString("krb5AuthzDataRealmBase.inquireSecurityContextFailed"), (Throwable)e);
            }
            if (adEntries == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)this.sm.getString("krb5AuthzDataRealmBase.noDataProvided", new Object[]{gssName}));
                }
                return null;
            }
            File catalinaBase = this.getServer().getCatalinaBase();
            Path workDir = catalinaBase.toPath().resolve("work");
            Instant id = Instant.now();
            Path dumpDir = workDir.resolve("KRB5_AUTHZ_DATA").resolve(gssName.toString());
            String lockKey = gssName + "#" + TS_FORMAT.format(id);
            AuthorizationDataEntry[] adEntriesCopy = adEntries;
            LOCKS.compute(lockKey, (k, v) -> {
                try {
                    Path dumpFile = this.createDumpFile(dumpDir, id);
                    try (PrintWriter w = new PrintWriter(Files.newBufferedWriter(dumpFile, new OpenOption[0]));){
                        for (AuthorizationDataEntry adEntry : adEntriesCopy) {
                            w.printf("%d %s%n", adEntry.getType(), Base64.getEncoder().encodeToString(adEntry.getData()));
                        }
                    }
                }
                catch (IOException e) {
                    this.logger.warn((Object)this.sm.getString("krb5AuthzDataDumpingActiveDirectoryRealm.dumpingKrb5AuthzDataFailed", new Object[]{gssName}), (Throwable)e);
                }
                return null;
            });
        } else {
            this.logger.error((Object)this.sm.getString("krb5AuthzDataRealmBase.incompatibleSecurityContextType"));
        }
        return null;
    }

    private Path createDumpFile(Path dumpDir, Instant id) throws IOException {
        Files.createDirectories(dumpDir, new FileAttribute[0]);
        String formattedTimestamp = TS_FORMAT.format(id);
        Path dumpFile = dumpDir.resolve(formattedTimestamp);
        int i = 2;
        while (Files.exists(dumpFile, new LinkOption[0])) {
            dumpFile = dumpDir.resolve(formattedTimestamp + "#" + i++);
        }
        if (FileSystems.getDefault().supportedFileAttributeViews().contains("posix")) {
            Set<PosixFilePermission> ownerWritable = PosixFilePermissions.fromString("rw-------");
            FileAttribute<Set<PosixFilePermission>> permissions = PosixFilePermissions.asFileAttribute(ownerWritable);
            Files.createFile(dumpFile, permissions);
        }
        return dumpFile;
    }
}

