/*
 * Decompiled with CFR 0.152.
 */
package net.sf.michaelo.tomcat.pac.asn1;

import com.sun.security.jgss.AuthorizationDataEntry;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.tomcat.util.buf.Asn1Parser;

public class AdIfRelevantAsn1Parser {
    public static final int AD_IF_RELEVANT = 1;
    public static final int AD_WIN2K_PAC = 128;

    private AdIfRelevantAsn1Parser() {
    }

    public static List<AuthorizationDataEntry> parse(byte[] adIfRelevant) {
        Objects.requireNonNull(adIfRelevant, "adIfRelevant cannot be null");
        if (adIfRelevant.length == 0) {
            throw new IllegalArgumentException("adIfRelevant cannot be empty");
        }
        ArrayList<AuthorizationDataEntry> adEntries = new ArrayList<AuthorizationDataEntry>();
        Asn1Parser parser = new Asn1Parser(adIfRelevant);
        parser.parseTagSequence();
        parser.parseFullLength();
        while (!parser.eof()) {
            parser.parseTagSequence();
            parser.parseLength();
            Asn1Parser p = new Asn1Parser(parser.parseAttributeAsBytes(0));
            BigInteger type = p.parseInt();
            p = new Asn1Parser(parser.parseAttributeAsBytes(1));
            byte[] data = p.parseOctetString();
            adEntries.add(new AuthorizationDataEntry(type.intValue(), data));
        }
        return adEntries;
    }
}

