/*
 * Decompiled with CFR 0.152.
 */
package net.sf.michaelo.tomcat.pac;

import java.security.Key;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.stream.Collectors;
import net.sf.michaelo.tomcat.pac.PacSignatureData;
import net.sf.michaelo.tomcat.pac.PacSignatureVerifierBase;
import sun.security.krb5.Checksum;
import sun.security.krb5.EncryptionKey;

public class PrivateSunPacSignatureVerifier
extends PacSignatureVerifierBase {
    @Override
    protected void verifyInternal(PacSignatureData signatureData, byte[] data, Key[] keys) throws SignatureException {
        PacSignatureData.SignatureType type = signatureData.getType();
        byte[] expectedSignature = signatureData.getSignature();
        ArrayList<byte[]> actualFailedSignatures = new ArrayList<byte[]>();
        for (int i = 0; i < keys.length; ++i) {
            Key key = keys[i];
            EncryptionKey encKey = new EncryptionKey(type.getEType(), key.getEncoded());
            Checksum checksum = null;
            try {
                checksum = new Checksum(type.getValue(), data, encKey, 17);
            }
            catch (Exception e) {
                throw new SignatureException("Failed to calculate signature", e);
            }
            byte[] actualSignature = checksum.getBytes();
            if (Arrays.equals(expectedSignature, actualSignature)) {
                return;
            }
            actualFailedSignatures.add(actualSignature);
        }
        String actualFailedSignaturesStr = actualFailedSignatures.stream().map(Base64.getEncoder()::encodeToString).collect(Collectors.joining(",", "[", "]"));
        throw new SignatureException("Calculated signatures " + actualFailedSignaturesStr + " do not match expected signature '" + Base64.getEncoder().encodeToString(expectedSignature) + "'");
    }
}

