/*
 * Decompiled with CFR 0.152.
 */
package net.sf.michaelo.tomcat.pac;

import java.math.BigInteger;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class PacDataBuffer {
    private static final BigInteger TWO_COMPL_REF = BigInteger.ONE.shiftLeft(64);
    private final ByteBuffer buf;

    public PacDataBuffer(byte[] pacDataBytes) {
        this.buf = ByteBuffer.wrap(pacDataBytes);
        this.buf.order(ByteOrder.LITTLE_ENDIAN);
    }

    public int position() {
        return this.buf.position();
    }

    public PacDataBuffer position(int newPosition) {
        ((Buffer)this.buf).position(newPosition);
        return this;
    }

    public PacDataBuffer skip(int bytes) {
        ((Buffer)this.buf).position(this.buf.position() + bytes);
        return this;
    }

    protected PacDataBuffer align(int bytes) {
        int shift = this.buf.position() & bytes - 1;
        if (bytes != 0 && shift != 0) {
            this.skip(bytes - shift);
        }
        return this;
    }

    public PacDataBuffer get(byte[] dst) {
        this.buf.get(dst);
        return this;
    }

    public int getInt() {
        this.align(4);
        return this.buf.getInt();
    }

    public int getUnsignedShort() {
        this.align(2);
        return this.buf.getShort() & 0xFFFF;
    }

    public long getUnsignedInt() {
        this.align(4);
        return (long)this.buf.getInt() & 0xFFFFFFFFL;
    }

    public BigInteger getUnsignedLong() {
        this.align(8);
        long temp = this.buf.getLong();
        BigInteger value = BigInteger.valueOf(temp);
        if (value.compareTo(BigInteger.ZERO) < 0) {
            value = value.add(TWO_COMPL_REF);
        }
        return value;
    }
}

