/*
 * Decompiled with CFR 0.152.
 */
package net.sf.michaelo.tomcat.pac;

import java.math.BigInteger;
import java.security.Key;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import net.sf.michaelo.tomcat.pac.KerbValidationInfo;
import net.sf.michaelo.tomcat.pac.PacClientInfo;
import net.sf.michaelo.tomcat.pac.PacDataBuffer;
import net.sf.michaelo.tomcat.pac.PacInfoBuffer;
import net.sf.michaelo.tomcat.pac.PacSignatureData;
import net.sf.michaelo.tomcat.pac.PacSignatureVerifier;
import net.sf.michaelo.tomcat.pac.UpnDnsInfo;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class Pac {
    private static final BigInteger EIGHT = BigInteger.valueOf(8L);
    private static final long KERB_VALIDATION_INFO = 1L;
    private static final long PAC_CLIENT_INFO = 10L;
    private static final long UPN_DNS_INFO = 12L;
    private static final long SERVER_SIGNATURE = 6L;
    private static final long KDC_SIGNATURE = 7L;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private KerbValidationInfo kerbValidationInfo;
    private UpnDnsInfo upnDnsInfo;
    private PacClientInfo pacClientInfo;
    private PacSignatureData serverSignature;
    private PacSignatureData kdcSignature;
    private final PacSignatureVerifier signatureVerifier;
    private final byte[] zeroedPacData;

    public Pac(byte[] pacDataBytes, PacSignatureVerifier signatureVerifier) {
        long type;
        Objects.requireNonNull(pacDataBytes, "pacDataBytes cannot be null");
        if (pacDataBytes.length == 0) {
            throw new IllegalArgumentException("pacDataBytes cannot be empty");
        }
        PacDataBuffer buf = new PacDataBuffer(pacDataBytes);
        this.signatureVerifier = Objects.requireNonNull(signatureVerifier, "signatureVerifier cannot be null");
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Parsing PACTYPE structure...");
        }
        long buffers = buf.getUnsignedInt();
        long version = buf.getUnsignedInt();
        if (version != 0L) {
            throw new IllegalArgumentException("PAC must have version 0, but has " + version);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("PAC has version " + version + " and contains " + buffers + " buffers"));
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Parsing " + buffers + " PAC_INFO_BUFFER structures..."));
        }
        ArrayList<PacInfoBuffer> pacInfoBuffers = new ArrayList<PacInfoBuffer>();
        for (long l = 0L; l < buffers; ++l) {
            type = buf.getUnsignedInt();
            long bufferSize = buf.getUnsignedInt();
            BigInteger offset = buf.getUnsignedLong();
            if (!offset.mod(EIGHT).equals(BigInteger.ZERO)) {
                throw new IllegalArgumentException("PAC_INFO_BUFFER offset must be multiple of 8, but is " + offset);
            }
            int pos = buf.position();
            buf.position(offset.intValue());
            byte[] data = new byte[(int)bufferSize];
            buf.get(data);
            buf.position(pos);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("PAC_INFO_BUFFER describes type " + String.format("0x%08X", type) + " with size " + bufferSize + " and offset " + offset + " containing data " + Base64.getEncoder().encodeToString(data)));
            }
            pacInfoBuffers.add(new PacInfoBuffer(type, bufferSize, offset, data));
        }
        this.zeroedPacData = Arrays.copyOf(pacDataBytes, pacDataBytes.length);
        for (PacInfoBuffer pacInfoBuffer : pacInfoBuffers) {
            int to;
            int from;
            type = pacInfoBuffer.getType();
            byte[] data = pacInfoBuffer.getData();
            if (type == 1L) {
                if (this.kerbValidationInfo != null) {
                    if (!this.logger.isTraceEnabled()) continue;
                    this.logger.trace((Object)"Ignoring additional KERB_VALIDATION_INFO structure");
                    continue;
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"Parsing KERB_VALIDATION_INFO structure...");
                }
                this.kerbValidationInfo = new KerbValidationInfo(data);
                continue;
            }
            if (type == 12L) {
                if (this.upnDnsInfo != null) {
                    if (!this.logger.isTraceEnabled()) continue;
                    this.logger.trace((Object)"Ignoring additional UPN_DNS_INFO structure");
                    continue;
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"Parsing UPN_DNS_INFO structure...");
                }
                this.upnDnsInfo = new UpnDnsInfo(data);
                continue;
            }
            if (type == 10L) {
                if (this.upnDnsInfo != null) {
                    if (!this.logger.isTraceEnabled()) continue;
                    this.logger.trace((Object)"Ignoring additional PAC_CLIENT_INFO structure");
                    continue;
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"Parsing PAC_CLIENT_INFO structure...");
                }
                this.pacClientInfo = new PacClientInfo(data);
                continue;
            }
            if (type == 6L) {
                if (this.serverSignature != null) {
                    if (!this.logger.isTraceEnabled()) continue;
                    this.logger.trace((Object)"Ignoring additional PAC_SIGNATURE_DATA (Server Signature) structure");
                    continue;
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"Parsing PAC_SIGNATURE_DATA (Server Signature) structure...");
                }
                this.serverSignature = new PacSignatureData(data);
                from = pacInfoBuffer.getOffset().intValue() + 4;
                to = from + this.serverSignature.getType().getSize();
                Arrays.fill(this.zeroedPacData, from, to, (byte)0);
                continue;
            }
            if (type == 7L) {
                if (this.kdcSignature != null) {
                    if (!this.logger.isTraceEnabled()) continue;
                    this.logger.trace((Object)"Ignoring additional PAC_SIGNATURE_DATA (KDC Signature) structure");
                    continue;
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"Parsing PAC_SIGNATURE_DATA (KDC Signature) structure...");
                }
                this.kdcSignature = new PacSignatureData(data);
                from = pacInfoBuffer.getOffset().intValue() + 4;
                to = from + this.kdcSignature.getType().getSize();
                Arrays.fill(this.zeroedPacData, from, to, (byte)0);
                continue;
            }
            if (!this.logger.isTraceEnabled()) continue;
            this.logger.trace((Object)("Ignoring unsupported structure type " + String.format("0x%08X", type) + " with data " + Base64.getEncoder().encodeToString(data)));
        }
        if (this.kerbValidationInfo == null) {
            throw new IllegalArgumentException("PAC does not contain required KERB_VALIDATION_INFO structure");
        }
        if (this.pacClientInfo == null) {
            throw new IllegalArgumentException("PAC does not contain required PAC_CLIENT_INFO structure");
        }
        if (this.serverSignature == null) {
            throw new IllegalArgumentException("PAC does not contain required PAC_SIGNATURE_DATA (Server Signature) structure");
        }
        if (this.kdcSignature == null) {
            throw new IllegalArgumentException("PAC does not contain required PAC_SIGNATURE_DATA (KDC Signature) structure");
        }
    }

    public KerbValidationInfo getKerbValidationInfo() {
        return this.kerbValidationInfo;
    }

    public UpnDnsInfo getUpnDnsInfo() {
        return this.upnDnsInfo;
    }

    public PacClientInfo getPacClientInfo() {
        return this.pacClientInfo;
    }

    public PacSignatureData getServerSignature() {
        return this.serverSignature;
    }

    public PacSignatureData getKdcSignature() {
        return this.kdcSignature;
    }

    public void verifySignature(Key[] keys) throws SignatureException {
        this.signatureVerifier.verify(this.serverSignature, this.zeroedPacData, keys);
    }
}

