/*
 * Decompiled with CFR 0.152.
 */
package net.sf.michaelo.tomcat.realm;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class Sid {
    public static final Sid NULL_SID = new Sid(new byte[]{1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    public static final Sid ANONYMOUS_SID = new Sid(new byte[]{1, 1, 0, 0, 0, 0, 0, 5, 7, 0, 0, 0});
    private byte[] bytes;
    private int revision;
    private int subAuthorityCount;
    private byte[] identifierAuthority;
    private long[] subAuthorities;
    private String sidString;

    public Sid(byte[] sidBytes) {
        if (sidBytes == null) {
            throw new NullPointerException("sidBytes cannot be null");
        }
        if (sidBytes.length < 12) {
            throw new IllegalArgumentException("SID must be at least 12 bytes long but is " + sidBytes.length);
        }
        ByteBuffer buf = ByteBuffer.wrap(sidBytes);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        this.revision = buf.get() & 0xFF;
        if (this.revision != 1) {
            throw new IllegalArgumentException("SID revision must be 1 but is " + this.revision);
        }
        this.subAuthorityCount = buf.get() & 0xFF;
        if (this.subAuthorityCount > 15) {
            throw new IllegalArgumentException("SID subauthority count must be at most 15 but is " + this.subAuthorityCount);
        }
        this.identifierAuthority = new byte[6];
        buf.get(this.identifierAuthority);
        StringBuilder sidStringBuilder = new StringBuilder("S");
        sidStringBuilder.append('-').append(this.revision);
        ByteBuffer iaBuf = ByteBuffer.allocate(8);
        ((Buffer)iaBuf).position(2);
        iaBuf.put(this.identifierAuthority);
        ((Buffer)iaBuf).flip();
        sidStringBuilder.append('-').append(iaBuf.getLong());
        this.subAuthorities = new long[this.subAuthorityCount];
        for (int b = 0; b < this.subAuthorityCount; b = (int)((byte)(b + 1))) {
            this.subAuthorities[b] = (long)buf.getInt() & 0xFFFFFFFFL;
            sidStringBuilder.append('-').append(this.subAuthorities[b]);
        }
        this.bytes = Arrays.copyOf(sidBytes, sidBytes.length);
        this.sidString = sidStringBuilder.toString();
    }

    public Sid append(long relativeId) {
        byte[] sidBytes = this.bytes;
        byte[] appendedSidBytes = new byte[sidBytes.length + 4];
        System.arraycopy(sidBytes, 0, appendedSidBytes, 0, sidBytes.length);
        appendedSidBytes[1] = (byte)(this.subAuthorityCount + 1);
        int signedRelativeId = (int)relativeId;
        appendedSidBytes[sidBytes.length + 0] = (byte)(signedRelativeId & 0xFF);
        appendedSidBytes[sidBytes.length + 1] = (byte)(signedRelativeId >> 8 & 0xFF);
        appendedSidBytes[sidBytes.length + 2] = (byte)(signedRelativeId >> 16 & 0xFF);
        appendedSidBytes[sidBytes.length + 3] = (byte)(signedRelativeId >> 24 & 0xFF);
        return new Sid(appendedSidBytes);
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Sid)) {
            return false;
        }
        Sid that = (Sid)obj;
        if (this == that) {
            return true;
        }
        return Arrays.equals(this.bytes, that.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public String toString() {
        return this.sidString;
    }
}

