/*
 * Decompiled with CFR 0.152.
 */
package net.sf.michaelo.tomcat.pac;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import net.sf.michaelo.tomcat.pac.PacDataBuffer;
import net.sf.michaelo.tomcat.realm.Sid;

public class UpnDnsInfo {
    public static final long UPN_CONSTRUCTED_FLAG = 1L;
    public static final long SAM_NAME_AND_SID_FLAG = 2L;
    private final String upn;
    private final String dnsDomainName;
    private final long flags;
    private String samName;
    private Sid sid;

    public UpnDnsInfo(byte[] infoBytes) {
        Objects.requireNonNull(infoBytes, "infoBytes cannot be null");
        if (infoBytes.length == 0) {
            throw new IllegalArgumentException("infoBytes cannot be empty");
        }
        PacDataBuffer buf = new PacDataBuffer(infoBytes);
        int upnLength = buf.getUnsignedShort();
        int upnOffset = buf.getUnsignedShort();
        int dnsDomainNameLength = buf.getUnsignedShort();
        int dnsDomainNameOffset = buf.getUnsignedShort();
        this.flags = buf.getUnsignedInt();
        int pos = buf.position();
        buf.position(upnOffset);
        this.upn = this.getUnicodeString(buf, upnLength);
        buf.position(dnsDomainNameOffset);
        this.dnsDomainName = this.getUnicodeString(buf, dnsDomainNameLength);
        buf.position(pos);
        if ((this.flags & 2L) != 0L) {
            int samNameLength = buf.getUnsignedShort();
            int samNameOffset = buf.getUnsignedShort();
            int sidLength = buf.getUnsignedShort();
            int sidOffset = buf.getUnsignedShort();
            pos = buf.position();
            buf.position(samNameOffset);
            this.samName = this.getUnicodeString(buf, samNameLength);
            byte[] dst = new byte[sidLength];
            buf.position(sidOffset);
            buf.get(dst);
            this.sid = new Sid(dst);
        }
    }

    public String getUpn() {
        return this.upn;
    }

    public String getDnsDomainName() {
        return this.dnsDomainName;
    }

    public long getFlags() {
        return this.flags;
    }

    public String getSamName() {
        return this.samName;
    }

    public Sid getSid() {
        return this.sid;
    }

    private String getUnicodeString(PacDataBuffer buf, int length) {
        byte[] dst = new byte[length];
        buf.get(dst);
        return new String(dst, StandardCharsets.UTF_16LE);
    }
}

