/*
 * Decompiled with CFR 0.152.
 */
package net.sf.michaelo.tomcat.pac;

import java.security.Key;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.sf.michaelo.tomcat.pac.PacSignatureData;
import net.sf.michaelo.tomcat.pac.PacSignatureVerifier;

public abstract class PacSignatureVerifierBase
implements PacSignatureVerifier {
    private static final Map<String, Integer> ETYPE_MAPPER = new HashMap<String, Integer>();

    @Override
    public void verify(PacSignatureData signatureData, byte[] data, Key[] keys) throws SignatureException {
        Objects.requireNonNull(signatureData, "signatureData cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        if (data.length == 0) {
            throw new IllegalArgumentException("data cannot be empty");
        }
        Objects.requireNonNull(keys, "data cannot be null");
        if (keys.length == 0) {
            throw new IllegalArgumentException("keys cannot be empty");
        }
        Key[] filteredKeys = (Key[])Arrays.stream(keys).filter(key -> ETYPE_MAPPER.get(key.getAlgorithm()) != null && ETYPE_MAPPER.get(key.getAlgorithm()).intValue() == signatureData.getType().getEType()).toArray(Key[]::new);
        if (filteredKeys.length == 0) {
            throw new IllegalArgumentException("No suitable keys provided for etype " + signatureData.getType().getEType());
        }
        this.verifyInternal(signatureData, data, filteredKeys);
    }

    protected abstract void verifyInternal(PacSignatureData var1, byte[] var2, Key[] var3) throws SignatureException;

    static {
        ETYPE_MAPPER.put("ArcFourHmac", PacSignatureData.SignatureType.HMAC_MD5.getEType());
        ETYPE_MAPPER.put("rc4-hmac", PacSignatureData.SignatureType.HMAC_MD5.getEType());
        ETYPE_MAPPER.put("23", PacSignatureData.SignatureType.HMAC_MD5.getEType());
        ETYPE_MAPPER.put("AES128", PacSignatureData.SignatureType.HMAC_SHA1_96_AES128.getEType());
        ETYPE_MAPPER.put("aes128-cts-hmac-sha1-96", PacSignatureData.SignatureType.HMAC_SHA1_96_AES128.getEType());
        ETYPE_MAPPER.put("17", PacSignatureData.SignatureType.HMAC_SHA1_96_AES128.getEType());
        ETYPE_MAPPER.put("AES256", PacSignatureData.SignatureType.HMAC_SHA1_96_AES256.getEType());
        ETYPE_MAPPER.put("aes256-cts-hmac-sha1-96", PacSignatureData.SignatureType.HMAC_SHA1_96_AES256.getEType());
        ETYPE_MAPPER.put("18", PacSignatureData.SignatureType.HMAC_SHA1_96_AES256.getEType());
    }
}

