/*
 * Decompiled with CFR 0.152.
 */
package net.sf.michaelo.tomcat.pac;

import java.util.Objects;
import net.sf.michaelo.tomcat.pac.PacDataBuffer;

public class PacSignatureData {
    private final SignatureType type;
    private final byte[] signature;

    public PacSignatureData(byte[] sigDataBytes) {
        Objects.requireNonNull(sigDataBytes, "sigDataBytes cannot be null");
        if (sigDataBytes.length == 0) {
            throw new IllegalArgumentException("sigDataBytes cannot be empty");
        }
        PacDataBuffer buf = new PacDataBuffer(sigDataBytes);
        int type = buf.getInt();
        if (type == SignatureType.HMAC_MD5.getValue()) {
            this.type = SignatureType.HMAC_MD5;
        } else if (type == SignatureType.HMAC_SHA1_96_AES128.getValue()) {
            this.type = SignatureType.HMAC_SHA1_96_AES128;
        } else if (type == SignatureType.HMAC_SHA1_96_AES256.getValue()) {
            this.type = SignatureType.HMAC_SHA1_96_AES256;
        } else {
            throw new IllegalArgumentException("Unsupported signature type " + type);
        }
        this.signature = new byte[this.type.getSize()];
        buf.get(this.signature);
    }

    public SignatureType getType() {
        return this.type;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public static enum SignatureType {
        HMAC_MD5(-138, 16, 23),
        HMAC_SHA1_96_AES128(15, 12, 17),
        HMAC_SHA1_96_AES256(16, 12, 18);

        private final int value;
        private final int size;
        private final int eType;

        private SignatureType(int value, int size, int eType) {
            this.value = value;
            this.size = size;
            this.eType = eType;
        }

        public int getValue() {
            return this.value;
        }

        public int getSize() {
            return this.size;
        }

        public int getEType() {
            return this.eType;
        }
    }
}

