/*
 * Decompiled with CFR 0.152.
 */
package net.sf.michaelo.tomcat.pac;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import net.sf.michaelo.tomcat.pac.PacDataBuffer;

public class PacClientInfo {
    private final String name;

    public PacClientInfo(byte[] infoBytes) {
        Objects.requireNonNull(infoBytes, "infoBytes cannot be null");
        if (infoBytes.length == 0) {
            throw new IllegalArgumentException("infoBytes cannot be empty");
        }
        PacDataBuffer buf = new PacDataBuffer(infoBytes);
        buf.skip(8);
        int nameLength = buf.getUnsignedShort();
        byte[] dst = new byte[nameLength];
        buf.get(dst);
        this.name = new String(dst, StandardCharsets.UTF_16LE);
    }

    public String getName() {
        return this.name;
    }
}

