/*
 * Decompiled with CFR 0.152.
 */
package net.sf.michaelo.tomcat.pac;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.sf.michaelo.tomcat.pac.GroupMembership;
import net.sf.michaelo.tomcat.pac.KerbSidAndAttributes;
import net.sf.michaelo.tomcat.pac.PacDataBuffer;
import net.sf.michaelo.tomcat.pac.RpcUnicodeString;
import net.sf.michaelo.tomcat.realm.Sid;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class KerbValidationInfo {
    public static final long EXTRA_SIDS_USER_FLAG = 32L;
    public static final long RESOURCE_GROUP_IDS_USER_FLAG = 512L;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final String effectiveName;
    private final String fullName;
    private final String logonScript;
    private final String profilePath;
    private final String homeDirectory;
    private final String homeDirectoryDrive;
    private final long userId;
    private final long primaryGroupId;
    private final List<GroupMembership> groupIds;
    private final long userFlags;
    private final String logonServer;
    private final String logonDomainName;
    private final Sid logonDomainId;
    private final long userAccountControl;
    private List<KerbSidAndAttributes> extraSids;
    private Sid resourceGroupDomainSid;
    private List<GroupMembership> resourceGroupIds;

    public KerbValidationInfo(byte[] infoBytes) {
        Objects.requireNonNull(infoBytes, "infoBytes cannot be null");
        if (infoBytes.length == 0) {
            throw new IllegalArgumentException("infoBytes cannot be empty");
        }
        PacDataBuffer buf = new PacDataBuffer(infoBytes);
        buf.skip(8);
        buf.skip(8);
        long uniquePointer = buf.getUnsignedInt();
        this.logPointer("RPC unique", uniquePointer);
        buf.skip(8);
        buf.skip(8);
        buf.skip(8);
        buf.skip(8);
        buf.skip(8);
        buf.skip(8);
        RpcUnicodeString effectiveName = this.getRpcUnicodeString(buf);
        RpcUnicodeString fullName = this.getRpcUnicodeString(buf);
        RpcUnicodeString logonScript = this.getRpcUnicodeString(buf);
        RpcUnicodeString profilePath = this.getRpcUnicodeString(buf);
        RpcUnicodeString homeDirectory = this.getRpcUnicodeString(buf);
        RpcUnicodeString homeDirectoryDrive = this.getRpcUnicodeString(buf);
        buf.skip(2);
        buf.skip(2);
        this.userId = buf.getUnsignedInt();
        this.primaryGroupId = buf.getUnsignedInt();
        long groupCount = buf.getUnsignedInt();
        long groupIdsPointer = buf.getUnsignedInt();
        this.userFlags = buf.getUnsignedInt();
        buf.skip(16);
        RpcUnicodeString logonServer = this.getRpcUnicodeString(buf);
        RpcUnicodeString logonDomainName = this.getRpcUnicodeString(buf);
        long logonDomainIdPointer = buf.getUnsignedInt();
        buf.skip(8);
        this.userAccountControl = buf.getUnsignedInt();
        buf.skip(4);
        buf.skip(8);
        buf.skip(8);
        buf.skip(4);
        buf.skip(4);
        long sidCount = buf.getUnsignedInt();
        long extraSidsPointer = buf.getUnsignedInt();
        long resourceGroupDomainSidPointer = buf.getUnsignedInt();
        long resourceGroupCount = buf.getUnsignedInt();
        long resourceGroupIdsPointer = buf.getUnsignedInt();
        this.logPointer("effectiveName", effectiveName.getPointer());
        this.effectiveName = this.getNdrString(buf, effectiveName);
        this.logPointer("fullName", fullName.getPointer());
        this.fullName = this.getNdrString(buf, fullName);
        this.logPointer("logonScript", logonScript.getPointer());
        this.logonScript = this.getNdrString(buf, logonScript);
        this.logPointer("profilePath", profilePath.getPointer());
        this.profilePath = this.getNdrString(buf, profilePath);
        this.logPointer("homeDirectory", homeDirectory.getPointer());
        this.homeDirectory = this.getNdrString(buf, homeDirectory);
        this.logPointer("homeDirectoryDrive", homeDirectoryDrive.getPointer());
        this.homeDirectoryDrive = this.getNdrString(buf, homeDirectoryDrive);
        long actualGroupCount = buf.getUnsignedInt();
        if (groupCount != actualGroupCount) {
            throw new IllegalArgumentException("GroupCount is " + groupCount + ", but actual GroupCount is " + actualGroupCount);
        }
        this.logPointer("groupIds", groupIdsPointer);
        this.groupIds = new ArrayList<GroupMembership>();
        for (long l = 0L; l < groupCount; ++l) {
            long relativeId = buf.getUnsignedInt();
            long attributes = buf.getUnsignedInt();
            this.groupIds.add(new GroupMembership(relativeId, attributes));
        }
        this.logPointer("logonServer", logonServer.getPointer());
        this.logonServer = this.getNdrString(buf, logonServer);
        this.logPointer("logonDomainName", logonDomainName.getPointer());
        this.logonDomainName = this.getNdrString(buf, logonDomainName);
        this.logPointer("logonDomainId", logonDomainIdPointer);
        this.logonDomainId = this.getRpcSid(buf);
        if (sidCount != 0L && (this.userFlags & 0x20L) == 0L) {
            throw new IllegalArgumentException("SidCount is " + sidCount + ", but flag D is not set in UserFlags (" + this.toHexString(this.userFlags) + ")");
        }
        if (extraSidsPointer != 0L && (this.userFlags & 0x20L) == 0L) {
            throw new IllegalArgumentException("ExtraSids is not null (" + this.toHexString(extraSidsPointer) + "), but flag D is not set in UserFlags (" + this.toHexString(this.userFlags) + ")");
        }
        if (extraSidsPointer != 0L) {
            long l;
            this.logPointer("extraSids", extraSidsPointer);
            this.extraSids = new ArrayList<KerbSidAndAttributes>();
            long actualSidCount = buf.getUnsignedInt();
            if (sidCount != actualSidCount) {
                throw new IllegalArgumentException("SidCount is " + sidCount + ", but actual SidCount is " + actualSidCount);
            }
            long[] sidAttrs = new long[(int)sidCount];
            for (l = 0L; l < sidCount; ++l) {
                long attributes;
                long extraSidPointer = buf.getUnsignedInt();
                sidAttrs[(int)l] = attributes = buf.getUnsignedInt();
                this.logPointer("extraSid (" + l + ")", extraSidPointer);
            }
            for (l = 0L; l < sidCount; ++l) {
                Sid extraSid = this.getRpcSid(buf);
                this.extraSids.add(new KerbSidAndAttributes(extraSid, sidAttrs[(int)l]));
            }
        }
        if (resourceGroupDomainSidPointer != 0L && (this.userFlags & 0x200L) == 0L) {
            throw new IllegalArgumentException("ResourceGroupDomainSid is not null (" + this.toHexString(resourceGroupDomainSidPointer) + "), but flag H is not set in UserFlags (" + this.toHexString(this.userFlags) + ")");
        }
        if (resourceGroupCount != 0L && (this.userFlags & 0x200L) == 0L) {
            throw new IllegalArgumentException("ResourceGroupCount is " + sidCount + ", but flag H is not set in UserFlags (" + this.toHexString(this.userFlags) + ")");
        }
        if (resourceGroupIdsPointer != 0L && (this.userFlags & 0x200L) == 0L) {
            throw new IllegalArgumentException("ResourceGroupIds is not null (" + this.toHexString(resourceGroupIdsPointer) + "), but flag H is not set in UserFlags (" + this.toHexString(this.userFlags) + ")");
        }
        if (resourceGroupDomainSidPointer != 0L) {
            this.logPointer("resourceGroupDomainSid", resourceGroupDomainSidPointer);
            this.resourceGroupDomainSid = this.getRpcSid(buf);
            long actualResourceGroupCount = buf.getUnsignedInt();
            if (resourceGroupCount != actualResourceGroupCount) {
                throw new IllegalArgumentException("ResourceGroupCount is " + resourceGroupCount + ", but actual ResourceGroupCount is " + actualResourceGroupCount);
            }
            if (resourceGroupIdsPointer != 0L) {
                this.logPointer("resourceGroupIds", resourceGroupIdsPointer);
                this.resourceGroupIds = new ArrayList<GroupMembership>();
                for (long l = 0L; l < resourceGroupCount; ++l) {
                    long relativeId = buf.getUnsignedInt();
                    long attributes = buf.getUnsignedInt();
                    this.resourceGroupIds.add(new GroupMembership(relativeId, attributes));
                }
            }
        }
    }

    public String getEffectiveName() {
        return this.effectiveName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getLogonScript() {
        return this.logonScript;
    }

    public String getProfilePath() {
        return this.profilePath;
    }

    public String getHomeDirectory() {
        return this.homeDirectory;
    }

    public String getHomeDirectoryDrive() {
        return this.homeDirectoryDrive;
    }

    public long getUserId() {
        return this.userId;
    }

    public long getPrimaryGroupId() {
        return this.primaryGroupId;
    }

    public List<GroupMembership> getGroupIds() {
        return Collections.unmodifiableList(this.groupIds);
    }

    public long getUserFlags() {
        return this.userFlags;
    }

    public String getLogonServer() {
        return this.logonServer;
    }

    public String getLogonDomainName() {
        return this.logonDomainName;
    }

    public Sid getLogonDomainId() {
        return this.logonDomainId;
    }

    public long getUserAccountControl() {
        return this.userAccountControl;
    }

    public List<KerbSidAndAttributes> getExtraSids() {
        return this.extraSids != null ? Collections.unmodifiableList(this.extraSids) : this.extraSids;
    }

    public Sid getResourceGroupDomainSid() {
        return this.resourceGroupDomainSid;
    }

    public List<GroupMembership> getResourceGroupIds() {
        return this.resourceGroupIds != null ? Collections.unmodifiableList(this.resourceGroupIds) : this.resourceGroupIds;
    }

    private RpcUnicodeString getRpcUnicodeString(PacDataBuffer buf) {
        int length = buf.getUnsignedShort();
        int maximumLength = buf.getUnsignedShort();
        if (maximumLength % 2 == 1) {
            --maximumLength;
        }
        long pointer = buf.getUnsignedInt();
        return new RpcUnicodeString(length, maximumLength, pointer);
    }

    private String getNdrString(PacDataBuffer buf, RpcUnicodeString string) {
        long maximumCount = buf.getUnsignedInt();
        long offset = buf.getUnsignedInt();
        long actualCount = buf.getUnsignedInt();
        if (offset > maximumCount || actualCount > maximumCount - offset) {
            throw new IllegalArgumentException("Incorrectly NDR-encoded UNICODE_STRING: maximumCount: " + maximumCount + ", offset: " + offset + ", actualCount: " + actualCount);
        }
        if (maximumCount != string.getMaximumLength() / 2L || actualCount != string.getLength() / 2L) {
            throw new IllegalArgumentException("NDR-encoded UNICODE_STRING does not match RPC_UNICODE_STRING: maximumCount: " + maximumCount + ", actualCount: " + actualCount + ", maximumLength: " + string.getMaximumLength() + ", length: " + string.getLength());
        }
        buf.skip(2 * (int)offset);
        byte[] dst = new byte[2 * (int)actualCount];
        buf.get(dst);
        return new String(dst, StandardCharsets.UTF_16LE);
    }

    private Sid getRpcSid(PacDataBuffer buf) {
        long actualSubAuthorityCount = buf.getUnsignedInt();
        byte[] sidBytes = new byte[8 + (int)actualSubAuthorityCount * 4];
        buf.get(sidBytes);
        return new Sid(sidBytes);
    }

    private void logPointer(String name, long pointer) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(name + " pointer: " + this.toHexString(pointer)));
        }
    }

    private String toHexString(long l) {
        return String.format("0x%08X", l);
    }
}

