/*
 * Decompiled with CFR 0.152.
 */
package net.sf.michaelo.tomcat.authenticator;

import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletResponse;
import net.sf.michaelo.tomcat.authenticator.GSSAuthenticatorBase;
import org.apache.catalina.Realm;
import org.apache.catalina.connector.Request;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;

public class CurrentWindowsIdentityAuthenticator
extends GSSAuthenticatorBase {
    protected static final String CURRENT_WINDOWS_IDENTITY_METHOD = "CURRENT_WINDOWS_IDENTITY";
    protected static final String CURRENT_WINDOWS_IDENTITY_AUTH_SCHEME = "CWI";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doAuthenticate(Request request, HttpServletResponse response) throws IOException {
        if (this.checkForCachedAuthentication(request, response, true)) {
            return true;
        }
        LoginContext lc = null;
        try {
            lc = new LoginContext(this.getLoginEntryName());
            lc.login();
        }
        catch (LoginException e) {
            this.logger.error((Object)this.sm.getString("cwiAuthenticator.obtainFailed"), (Throwable)e);
            this.sendUnauthorized(request, response, CURRENT_WINDOWS_IDENTITY_AUTH_SCHEME, "cwiAuthenticator.obtainFailed", new Object[0]);
            boolean bl = false;
            if (lc != null) {
                try {
                    lc.logout();
                }
                catch (LoginException loginException) {
                    // empty catch block
                }
            }
            return bl;
        }
        GSSManager manager = GSSManager.getInstance();
        PrivilegedExceptionAction<GSSCredential> action = () -> manager.createCredential(null, Integer.MAX_VALUE, KRB5_MECHANISM, 1);
        GSSCredential gssCredential = null;
        try {
            gssCredential = Subject.doAs(lc.getSubject(), action);
        }
        catch (PrivilegedActionException e) {
            this.logger.error((Object)this.sm.getString("cwiAuthenticator.obtainFailed"), (Throwable)e.getException());
            this.sendUnauthorized(request, response, CURRENT_WINDOWS_IDENTITY_AUTH_SCHEME, "cwiAuthenticator.obtainFailed", new Object[0]);
            boolean bl = false;
            if (lc != null) {
                try {
                    lc.logout();
                }
                catch (LoginException loginException) {
                    // empty catch block
                }
            }
            return bl;
        }
        Realm realm = this.context.getRealm();
        GSSName gssName = gssCredential.getName();
        Principal principal = realm.authenticate(gssName, this.isStoreDelegatedCredential() ? gssCredential : null);
        if (principal != null) {
            this.register(request, response, principal, this.getAuthMethod(), principal.getName(), null);
            boolean bl = true;
            return bl;
        }
        this.sendUnauthorized(request, response, CURRENT_WINDOWS_IDENTITY_AUTH_SCHEME, "gssAuthenticatorBase.userNotFound", gssName);
        boolean bl = false;
        return bl;
        finally {
            if (lc != null) {
                try {
                    lc.logout();
                }
                catch (LoginException loginException) {}
            }
        }
    }

    protected String getAuthMethod() {
        return CURRENT_WINDOWS_IDENTITY_METHOD;
    }
}

