/*
 * Decompiled with CFR 0.152.
 */
package net.sf.michaelo.tomcat.realm.mapper;

import java.util.Arrays;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import net.sf.michaelo.tomcat.realm.mapper.UsernameSearchMapper;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class UserPrincipalNameSearchMapper
implements UsernameSearchMapper {
    protected static final Oid KRB5_NT_PRINCIPAL;
    protected static final Oid KRB5_NT_ENTERPRISE_PRINCIPAL;
    protected static final Oid MS_UPN;
    private static final Oid[] SUPPORTED_STRING_NAME_TYPES;

    @Override
    public Oid[] getSupportedStringNameTypes() {
        return Arrays.copyOf(SUPPORTED_STRING_NAME_TYPES, SUPPORTED_STRING_NAME_TYPES.length);
    }

    @Override
    public boolean supportsGssName(GSSName gssName) {
        try {
            return gssName.getStringNameType().containedIn(SUPPORTED_STRING_NAME_TYPES);
        }
        catch (GSSException e) {
            return false;
        }
    }

    @Override
    public synchronized UsernameSearchMapper.MappedValues map(DirContext context, GSSName gssName) throws NamingException {
        if (!this.supportsGssName(gssName)) {
            throw new IllegalArgumentException("GSS name '" + gssName + "' is not supported");
        }
        return new UserPrincipalNameMappedValues(gssName.toString());
    }

    static {
        try {
            KRB5_NT_PRINCIPAL = new Oid("1.2.840.113554.1.2.2.1");
        }
        catch (GSSException e) {
            throw new IllegalStateException("Failed to create OID for KRB5_NT_PRINCIPAL");
        }
        try {
            KRB5_NT_ENTERPRISE_PRINCIPAL = new Oid("1.2.840.113554.1.2.2.6");
        }
        catch (GSSException e) {
            throw new IllegalStateException("Failed to create OID for KRB5_NT_ENTERPRISE_PRINCIPAL");
        }
        try {
            MS_UPN = new Oid("1.3.6.1.4.1.311.20.2.3");
        }
        catch (GSSException e) {
            throw new IllegalStateException("Failed to create OID for MS_UPN");
        }
        SUPPORTED_STRING_NAME_TYPES = new Oid[]{MS_UPN, KRB5_NT_ENTERPRISE_PRINCIPAL, KRB5_NT_PRINCIPAL};
    }

    protected static class UserPrincipalNameMappedValues
    implements UsernameSearchMapper.MappedValues {
        private String searchUsername;

        protected UserPrincipalNameMappedValues(String searchUsername) {
            this.searchUsername = searchUsername;
        }

        @Override
        public String getSearchBase() {
            return "";
        }

        @Override
        public String getSearchAttributeName() {
            return "userPrincipalName";
        }

        @Override
        public String getSearchUsername() {
            return this.searchUsername;
        }
    }
}

