/*
 * Decompiled with CFR 0.152.
 */
package net.sf.michaelo.tomcat.realm.asn1;

import java.util.Objects;
import net.sf.michaelo.tomcat.realm.asn1.OtherNameParseResult;
import org.apache.tomcat.util.buf.Asn1Parser;

public class OtherNameAsn1Parser {
    private OtherNameAsn1Parser() {
    }

    public static OtherNameParseResult parse(byte[] otherName) {
        Objects.requireNonNull(otherName, "otherName cannot be null");
        if (otherName.length == 0) {
            throw new IllegalArgumentException("otherName cannot be empty");
        }
        Asn1Parser parser = new Asn1Parser(otherName);
        parser.parseTagSequence();
        parser.parseFullLength();
        byte[] typeId = parser.parseOIDAsBytes();
        byte[] value = parser.parseAttributeAsBytes(0);
        parser = new Asn1Parser(value);
        if (parser.peekTag() == 160) {
            value = parser.parseAttributeAsBytes(0);
        }
        return new OtherNameParseResult(typeId, value);
    }
}

