/*
 * Decompiled with CFR 0.152.
 */
package net.sf.michaelo.tomcat.realm;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.naming.CommunicationException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.ReferralException;
import javax.naming.ServiceUnavailableException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import net.sf.michaelo.dirctxsrc.DirContextSource;
import net.sf.michaelo.tomcat.realm.ActiveDirectoryPrincipal;
import net.sf.michaelo.tomcat.realm.ActiveDirectoryRealmBase;
import net.sf.michaelo.tomcat.realm.Sid;
import net.sf.michaelo.tomcat.realm.StubGSSName;
import net.sf.michaelo.tomcat.realm.asn1.OtherNameAsn1Parser;
import net.sf.michaelo.tomcat.realm.asn1.OtherNameParseResult;
import net.sf.michaelo.tomcat.realm.mapper.SamAccountNameRfc2247Mapper;
import net.sf.michaelo.tomcat.realm.mapper.UserPrincipalNameSearchMapper;
import net.sf.michaelo.tomcat.realm.mapper.UsernameSearchMapper;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Server;
import org.apache.naming.ContextBindings;
import org.apache.tomcat.util.buf.Asn1Parser;
import org.apache.tomcat.util.collections.SynchronizedStack;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class ActiveDirectoryRealm
extends ActiveDirectoryRealmBase {
    private static final AtomicLong COUNT = new AtomicLong(0L);
    private static final byte[] MS_UPN_OID_BYTES = new byte[]{43, 6, 1, 4, 1, -126, 55, 20, 2, 3};
    private static final long UF_ACCOUNT_DISABLE = 2L;
    private static final long UF_NORMAL_ACCOUNT = 512L;
    private static final long UF_WORKSTATION_TRUST_ACCOUNT = 4096L;
    private static final Oid MS_UPN;
    private static final Oid KRB5_NT_PRINCIPAL;
    private static final Map<String, String> X500_PRINCIPAL_OID_MAP;
    private static final UsernameSearchMapper[] USERNAME_SEARCH_MAPPERS;
    private static final String[] DEFAULT_USER_ATTRIBUTES;
    private static final String[] DEFAULT_ROLE_ATTRIBUTES;
    private static final String DEFAULT_ROLE_FORMAT = "sid";
    private static final Map<String, String[]> ROLE_FORMAT_ATTRIBUTES;
    protected boolean localDirContextSource;
    protected String dirContextSourceName;
    protected String[] attributes;
    protected String[] additionalAttributes;
    protected String[] roleFormats;
    protected String[] roleAttributes;
    protected boolean prependRoleFormat;
    protected int connectionPoolSize = 0;
    protected long maxIdleTime = 900000L;
    protected SynchronizedStack<DirContextConnection> connectionPool;

    protected static String getNextConnectionId() {
        return String.format("conn-%06d", COUNT.incrementAndGet());
    }

    public void setLocalDirContextSource(boolean localDirContextSource) {
        this.localDirContextSource = localDirContextSource;
    }

    public void setDirContextSourceName(String dirContextSourceName) {
        this.dirContextSourceName = dirContextSourceName;
    }

    public void setAdditionalAttributes(String additionalAttributes) {
        this.additionalAttributes = additionalAttributes.split(",");
        this.attributes = new String[DEFAULT_USER_ATTRIBUTES.length + this.additionalAttributes.length];
        System.arraycopy(DEFAULT_USER_ATTRIBUTES, 0, this.attributes, 0, DEFAULT_USER_ATTRIBUTES.length);
        System.arraycopy(this.additionalAttributes, 0, this.attributes, DEFAULT_USER_ATTRIBUTES.length, this.additionalAttributes.length);
    }

    public void setRoleFormats(String roleFormats) {
        this.roleFormats = roleFormats.split(",");
        ArrayList<String> attributes = new ArrayList<String>(Arrays.asList(DEFAULT_ROLE_ATTRIBUTES));
        for (String roleFormat : this.roleFormats) {
            if (ROLE_FORMAT_ATTRIBUTES.get(roleFormat) == null) continue;
            attributes.addAll(Arrays.asList(ROLE_FORMAT_ATTRIBUTES.get(roleFormat)));
        }
        this.roleAttributes = attributes.toArray(new String[0]);
    }

    public void setPrependRoleFormat(boolean prependRoleFormat) {
        this.prependRoleFormat = prependRoleFormat;
    }

    public void setConnectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
    }

    public void setMaxIdleTime(long maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    protected Principal getPrincipal(X509Certificate userCert) {
        try {
            Collection<List<?>> san = userCert.getSubjectAlternativeNames();
            if (san == null || san.isEmpty()) {
                return null;
            }
            String dn = userCert.getSubjectX500Principal().getName("RFC2253", X500_PRINCIPAL_OID_MAP);
            for (List<?> sanField : san) {
                Integer nameType = (Integer)sanField.get(0);
                if (nameType != 0) continue;
                byte[] otherName = (byte[])sanField.get(1);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)this.sm.getString("activeDirectoryRealm.processingSanOtherName", new Object[]{Base64.getEncoder().encodeToString(otherName), dn}));
                }
                try {
                    OtherNameParseResult result = OtherNameAsn1Parser.parse(otherName);
                    if (!Arrays.equals(result.getTypeId(), MS_UPN_OID_BYTES)) continue;
                    Asn1Parser parser = new Asn1Parser(result.getValue());
                    String upn = parser.parseUTF8String();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)this.sm.getString("activeDirectoryRealm.msUpnExtracted", new Object[]{upn, dn}));
                    }
                    StubGSSName gssName = new StubGSSName(upn, MS_UPN);
                    return this.getPrincipal(gssName, null, true);
                }
                catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
                    this.logger.warn((Object)this.sm.getString("activeDirectoryRealm.sanOtherNameParsingFailed"), (Throwable)e);
                }
            }
        }
        catch (CertificateParsingException e) {
            this.logger.warn((Object)this.sm.getString("activeDirectoryRealm.sanParsingFailed"), (Throwable)e);
        }
        return null;
    }

    protected Principal getPrincipal(GSSName gssName, GSSCredential gssCredential) {
        if (gssName.isAnonymous()) {
            return new ActiveDirectoryPrincipal(gssName, Sid.ANONYMOUS_SID, gssCredential);
        }
        return this.getPrincipal(gssName, gssCredential, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Principal getPrincipal(GSSName gssName, GSSCredential gssCredential, boolean retry) {
        DirContextConnection connection = null;
        try {
            connection = this.acquire();
            try {
                User user = this.getUser(connection.context, gssName);
                if (user != null) {
                    List<String> roles = this.getRoles(connection.context, user);
                    ActiveDirectoryPrincipal activeDirectoryPrincipal = new ActiveDirectoryPrincipal(user.getGssName(), user.getSid(), roles, gssCredential, user.getAdditionalAttributes());
                    return activeDirectoryPrincipal;
                }
            }
            catch (NamingException e) {
                boolean canRetry = false;
                if (e instanceof CommunicationException || e instanceof ServiceUnavailableException) {
                    canRetry = true;
                } else {
                    String explanation = e.getExplanation();
                    if (explanation.equals("LDAP connection has been closed") || explanation.startsWith("LDAP response read timed out, timeout used:")) {
                        canRetry = true;
                    }
                }
                if (retry && canRetry) {
                    this.logger.error((Object)this.sm.getString("activeDirectoryRealm.principalSearchFailed.retry", new Object[]{gssName}), (Throwable)e);
                    this.close(connection);
                    Principal principal = this.getPrincipal(gssName, gssCredential, false);
                    return principal;
                }
                this.logger.error((Object)this.sm.getString("activeDirectoryRealm.principalSearchFailed", new Object[]{gssName}), (Throwable)e);
                this.close(connection);
            }
        }
        catch (NamingException e) {
            this.logger.error((Object)this.sm.getString("activeDirectoryRealm.acquire.namingException"), (Throwable)e);
        }
        finally {
            this.release(connection);
        }
        return null;
    }

    protected DirContextConnection acquire() throws NamingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)this.sm.getString("activeDirectoryRealm.acquire"));
        }
        DirContextConnection connection = null;
        while (connection == null) {
            connection = (DirContextConnection)this.connectionPool.pop();
            if (connection != null) {
                long idleTime = System.currentTimeMillis() - connection.lastBorrowTime;
                if (idleTime > this.maxIdleTime) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)this.sm.getString("activeDirectoryRealm.exceedMaxIdleTime", new Object[]{connection.id}));
                    }
                    this.close(connection);
                    connection = null;
                    continue;
                }
                boolean valid = this.validate(connection);
                if (valid) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)this.sm.getString("activeDirectoryRealm.reuse", new Object[]{connection.id}));
                    continue;
                }
                this.close(connection);
                connection = null;
                continue;
            }
            connection = new DirContextConnection();
            this.open(connection);
        }
        connection.lastBorrowTime = System.currentTimeMillis();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)this.sm.getString("activeDirectoryRealm.acquired", new Object[]{connection.id}));
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validate(DirContextConnection connection) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)this.sm.getString("activeDirectoryRealm.validate", new Object[]{connection.id}));
        }
        SearchControls controls = new SearchControls();
        controls.setSearchScope(0);
        controls.setCountLimit(1L);
        controls.setReturningAttributes(new String[]{"objectClass"});
        controls.setTimeLimit(500);
        NamingEnumeration<SearchResult> results = null;
        try {
            results = connection.context.search("", "objectclass=*", controls);
            if (results.hasMore()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (NamingException e) {
            this.logger.error((Object)this.sm.getString("activeDirectoryRealm.validate.namingException", new Object[]{connection.id}), (Throwable)e);
        }
        finally {
            this.close(results);
        }
        return false;
    }

    protected void release(DirContextConnection connection) {
        if (connection == null) {
            return;
        }
        if (connection.context == null) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)this.sm.getString("activeDirectoryRealm.release", new Object[]{connection.id}));
        }
        if (!this.connectionPool.push((Object)connection)) {
            this.close(connection);
        }
    }

    protected void open(DirContextConnection connection) throws NamingException {
        Context context = null;
        if (this.localDirContextSource) {
            context = ContextBindings.getClassLoader();
            context = (Context)context.lookup("comp/env");
        } else {
            Server server = this.getServer();
            context = server.getGlobalNamingContext();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)this.sm.getString("activeDirectoryRealm.open"));
        }
        DirContextSource contextSource = (DirContextSource)context.lookup(this.dirContextSourceName);
        connection.context = contextSource.getDirContext();
        connection.id = ActiveDirectoryRealm.getNextConnectionId();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)this.sm.getString("activeDirectoryRealm.opened", new Object[]{connection.id}));
        }
    }

    protected void close(DirContextConnection connection) {
        if (connection.context == null) {
            return;
        }
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)this.sm.getString("activeDirectoryRealm.close", new Object[]{connection.id}));
            }
            connection.context.close();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)this.sm.getString("activeDirectoryRealm.closed", new Object[]{connection.id}));
            }
        }
        catch (NamingException e) {
            this.logger.error((Object)this.sm.getString("activeDirectoryRealm.close.namingException", new Object[]{connection.id}), (Throwable)e);
        }
        connection.context = null;
    }

    protected void close(NamingEnumeration<?> results) {
        if (results == null) {
            return;
        }
        try {
            results.close();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    protected void initInternal() throws LifecycleException {
        super.initInternal();
        if (this.attributes == null) {
            this.attributes = DEFAULT_USER_ATTRIBUTES;
        }
        if (this.roleFormats == null) {
            this.setRoleFormats(DEFAULT_ROLE_FORMAT);
        }
    }

    protected void startInternal() throws LifecycleException {
        this.connectionPool = new SynchronizedStack(this.connectionPoolSize, this.connectionPoolSize);
        DirContextConnection connection = null;
        try {
            connection = this.acquire();
            try {
                String referral = (String)connection.context.getEnvironment().get("java.naming.referral");
                if ("follow".equals(referral)) {
                    this.logger.warn((Object)this.sm.getString("activeDirectoryRealm.referralFollow"));
                }
            }
            catch (NamingException e) {
                this.logger.error((Object)this.sm.getString("activeDirectoryRealm.environmentFailed"), (Throwable)e);
                this.close(connection);
            }
        }
        catch (NamingException e) {
            this.logger.error((Object)this.sm.getString("activeDirectoryRealm.acquire.namingException"), (Throwable)e);
        }
        finally {
            this.release(connection);
        }
        super.startInternal();
    }

    protected void stopInternal() throws LifecycleException {
        super.stopInternal();
        DirContextConnection connection = null;
        while ((connection = (DirContextConnection)this.connectionPool.pop()) != null) {
            this.close(connection);
        }
        this.connectionPool = null;
    }

    private Oid getStringNameType(GSSName gssName) {
        try {
            return gssName.getStringNameType();
        }
        catch (GSSException e) {
            return null;
        }
    }

    private String toRealm(Name distinguishedName) {
        LdapName dn = (LdapName)distinguishedName;
        StringBuilder realm = new StringBuilder();
        for (Rdn rdn : dn.getRdns()) {
            if (!rdn.getType().equalsIgnoreCase("DC")) continue;
            realm.insert(0, ((String)rdn.getValue()).toUpperCase(Locale.ROOT) + ".");
        }
        if (realm.length() > 0) {
            realm.deleteCharAt(realm.length() - 1);
        }
        return realm.toString();
    }

    protected User getUser(DirContext context, GSSName gssName) throws NamingException {
        SearchControls searchCtls = new SearchControls();
        searchCtls.setSearchScope(2);
        searchCtls.setReturningAttributes(this.attributes);
        Name searchBase = null;
        NamingEnumeration<SearchResult> results = null;
        for (UsernameSearchMapper mapper : USERNAME_SEARCH_MAPPERS) {
            String mapperClassName = mapper.getClass().getSimpleName();
            if (!mapper.supportsGssName(gssName)) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)this.sm.getString("activeDirectoryRealm.nameTypeNotSupported", new Object[]{mapperClassName, this.getStringNameType(gssName), gssName}));
                continue;
            }
            UsernameSearchMapper.MappedValues mappedValues = mapper.map(context, gssName);
            searchBase = this.getRelativeName(context, mappedValues.getSearchBase());
            String searchAttributeName = mappedValues.getSearchAttributeName();
            String searchAttributeValue = mappedValues.getSearchUsername();
            String searchFilter = String.format("(%s={0})", searchAttributeName);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)this.sm.getString("activeDirectoryRealm.usernameSearch", new Object[]{searchAttributeValue, searchBase, searchAttributeName, mapperClassName}));
            }
            try {
                results = context.search(searchBase, searchFilter, new Object[]{searchAttributeValue}, searchCtls);
            }
            catch (ReferralException e) {
                this.logger.warn((Object)this.sm.getString("activeDirectoryRealm.user.referralException", new Object[]{mapperClassName, e.getRemainingName(), e.getReferralInfo()}));
                continue;
            }
            try {
                if (results.hasMore()) break;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)this.sm.getString("activeDirectoryRealm.userNotFoundWithMapper", new Object[]{gssName, mapperClassName}));
                }
                this.close(results);
            }
            catch (PartialResultException e) {
                this.logger.debug((Object)this.sm.getString("activeDirectoryRealm.user.partialResultException", new Object[]{mapperClassName, e.getRemainingName()}));
                this.close(results);
            }
        }
        if (results == null || !results.hasMore()) {
            this.logger.debug((Object)this.sm.getString("activeDirectoryRealm.userNotFound", new Object[]{gssName}));
            this.close(results);
            return null;
        }
        SearchResult result = (SearchResult)results.next();
        try {
            if (results.hasMore()) {
                this.logger.error((Object)this.sm.getString("activeDirectoryRealm.duplicateUser", new Object[]{gssName}));
                this.close(results);
                return null;
            }
        }
        catch (ReferralException e) {
            this.logger.warn((Object)this.sm.getString("activeDirectoryRealm.duplicateUser.referralException", new Object[]{gssName, e.getRemainingName(), e.getReferralInfo()}));
        }
        catch (PartialResultException e) {
            this.logger.debug((Object)this.sm.getString("activeDirectoryRealm.duplicateUser.partialResultException", new Object[]{gssName, e.getRemainingName()}));
        }
        this.close(results);
        Attributes userAttributes = result.getAttributes();
        long userAccountControl = Long.parseLong((String)userAttributes.get("userAccountControl").get());
        if ((userAccountControl & 2L) != 0L) {
            this.logger.warn((Object)this.sm.getString("activeDirectoryRealm.userFoundButDisabled", new Object[]{gssName}));
            return null;
        }
        if ((userAccountControl & 0x200L) == 0L && (userAccountControl & 0x1000L) == 0L) {
            this.logger.warn((Object)this.sm.getString("activeDirectoryRealm.userFoundButNotSupported", new Object[]{gssName}));
            return null;
        }
        Name dn = this.getDistinguishedName(context, searchBase, result);
        byte[] sidBytes = (byte[])userAttributes.get("objectSid;binary").get();
        Sid sid = new Sid(sidBytes);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)this.sm.getString("activeDirectoryRealm.userFound", new Object[]{gssName, dn, sid}));
        }
        if (!KRB5_NT_PRINCIPAL.equals(this.getStringNameType(gssName))) {
            String samAccountName = (String)userAttributes.get("sAMAccountName").get();
            String realm = this.toRealm(dn);
            String krb5Principal = samAccountName + "@" + realm;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)this.sm.getString("activeDirectoryRealm.canonicalizingUser", new Object[]{this.getStringNameType(gssName), KRB5_NT_PRINCIPAL}));
            }
            GSSName canonGssName = null;
            try {
                canonGssName = GSSManager.getInstance().createName(krb5Principal, KRB5_NT_PRINCIPAL);
            }
            catch (GSSException e) {
                this.logger.warn((Object)this.sm.getString("activeDirectoryRealm.canonicalizeUserFailed", new Object[]{gssName}));
                return null;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)this.sm.getString("activeDirectoryRealm.userCanonicalized", new Object[]{canonGssName}));
            }
            gssName = canonGssName;
        }
        Attribute memberOfAttr = userAttributes.get("memberOf");
        LinkedList<String> memberOfs = new LinkedList<String>();
        if (memberOfAttr != null && memberOfAttr.size() > 0) {
            NamingEnumeration<?> memberOfValues = memberOfAttr.getAll();
            while (memberOfValues.hasMore()) {
                memberOfs.add((String)memberOfValues.next());
            }
            this.close(memberOfValues);
        }
        Map<String, Object> additionalAttributesMap = Collections.emptyMap();
        if (this.additionalAttributes != null && this.additionalAttributes.length > 0) {
            additionalAttributesMap = new HashMap<String, Object>();
            for (String addAttr : this.additionalAttributes) {
                Attribute attr = userAttributes.get(addAttr);
                if (attr == null || attr.size() <= 0) continue;
                if (attr.size() > 1) {
                    ArrayList attrList = new ArrayList(attr.size());
                    NamingEnumeration<?> attrEnum = attr.getAll();
                    while (attrEnum.hasMore()) {
                        attrList.add(attrEnum.next());
                    }
                    this.close(attrEnum);
                    additionalAttributesMap.put(addAttr, Collections.unmodifiableList(attrList));
                    continue;
                }
                additionalAttributesMap.put(addAttr, attr.get());
            }
        }
        return new User(gssName, sid, memberOfs, additionalAttributesMap);
    }

    protected List<String> getRoles(DirContext context, User user) throws NamingException {
        LinkedList<String> roles = new LinkedList<String>();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)this.sm.getString("activeDirectoryRealm.retrievingRoles", new Object[]{user.getRoles().size(), user.getGssName()}));
        }
        for (String role : user.getRoles()) {
            Name roleRdn = this.getRelativeName(context, role);
            Attributes roleAttributes = null;
            try {
                roleAttributes = context.getAttributes(roleRdn, this.roleAttributes);
            }
            catch (ReferralException e) {
                this.logger.warn((Object)this.sm.getString("activeDirectoryRealm.role.referralException", new Object[]{role, e.getRemainingName(), e.getReferralInfo()}));
                continue;
            }
            catch (PartialResultException e) {
                this.logger.debug((Object)this.sm.getString("activeDirectoryRealm.role.partialResultException", new Object[]{role, e.getRemainingName()}));
                continue;
            }
            int groupType = Integer.parseInt((String)roleAttributes.get("groupType").get());
            if ((groupType & Integer.MIN_VALUE) == 0) {
                if (!this.logger.isTraceEnabled()) continue;
                this.logger.trace((Object)this.sm.getString("activeDirectoryRealm.skippingDistributionRole", new Object[]{role}));
                continue;
            }
            block14: for (String roleFormat : this.roleFormats) {
                String roleFormatPrefix = this.prependRoleFormat ? roleFormat + ":" : "";
                switch (roleFormat) {
                    case "sid": {
                        byte[] objectSidBytes = (byte[])roleAttributes.get("objectSid;binary").get();
                        String sidString = new Sid(objectSidBytes).toString();
                        roles.add(roleFormatPrefix + sidString);
                        Attribute sidHistory = roleAttributes.get("sIDHistory;binary");
                        LinkedList<String> sidHistoryStrings = new LinkedList<String>();
                        if (sidHistory != null) {
                            NamingEnumeration<?> sidHistoryEnum = sidHistory.getAll();
                            while (sidHistoryEnum.hasMore()) {
                                byte[] sidHistoryBytes = (byte[])sidHistoryEnum.next();
                                String sidHistoryString = new Sid(sidHistoryBytes).toString();
                                sidHistoryStrings.add(sidHistoryString);
                                roles.add(roleFormatPrefix + sidHistoryString);
                            }
                            this.close(sidHistoryEnum);
                        }
                        if (!this.logger.isTraceEnabled()) continue block14;
                        if (sidHistoryStrings.isEmpty()) {
                            this.logger.trace((Object)this.sm.getString("activeDirectoryRealm.foundRoleSidConverted", new Object[]{role, sidString}));
                            continue block14;
                        }
                        this.logger.trace((Object)this.sm.getString("activeDirectoryRealm.foundRoleSidConverted.withSidHistory", new Object[]{role, sidString, sidHistoryStrings}));
                        continue block14;
                    }
                    case "name": {
                        String msDsPrincipalName = (String)roleAttributes.get("msDS-PrincipalName").get();
                        roles.add(roleFormatPrefix + msDsPrincipalName);
                        if (!this.logger.isTraceEnabled()) continue block14;
                        this.logger.trace((Object)this.sm.getString("activeDirectoryRealm.foundRoleNameConverted", new Object[]{role, msDsPrincipalName}));
                        continue block14;
                    }
                    case "nameEx": {
                        String distinguishedName = (String)roleAttributes.get("distinguishedName").get();
                        String samAccountName = (String)roleAttributes.get("sAMAccountName").get();
                        NameParser parser = context.getNameParser("");
                        LdapName dn = (LdapName)parser.parse(distinguishedName);
                        String realm = this.toRealm(dn);
                        String nameEx = realm + "\\" + samAccountName;
                        roles.add(roleFormatPrefix + nameEx);
                        if (!this.logger.isTraceEnabled()) continue block14;
                        this.logger.trace((Object)this.sm.getString("activeDirectoryRealm.foundRoleNameExConverted", new Object[]{role, nameEx}));
                        continue block14;
                    }
                    default: {
                        throw new IllegalArgumentException("The role format '" + roleFormat + "' is invalid");
                    }
                }
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)this.sm.getString("activeDirectoryRealm.foundRoles", new Object[]{roles.size(), user.getGssName(), roles}));
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)this.sm.getString("activeDirectoryRealm.foundRolesCount", new Object[]{roles.size(), user.getGssName()}));
        }
        return roles;
    }

    protected Name getDistinguishedName(DirContext context, Name baseName, SearchResult result) throws NamingException {
        String resultName = result.getName();
        if (result.isRelative()) {
            NameParser parser = context.getNameParser("");
            Name contextName = parser.parse(context.getNameInNamespace());
            Name entryName = parser.parse(new CompositeName(resultName).get(0));
            Name name = contextName.addAll(baseName);
            return name.addAll(entryName);
        }
        String absoluteName = result.getName();
        try {
            NameParser parser = context.getNameParser("");
            URI userNameUri = new URI(resultName);
            String pathComponent = userNameUri.getPath();
            if (pathComponent.length() < 1) {
                throw new InvalidNameException(this.sm.getString("activeDirectoryRealm.unparseableName", new Object[]{absoluteName}));
            }
            return parser.parse(pathComponent.substring(1));
        }
        catch (URISyntaxException e) {
            throw new InvalidNameException(this.sm.getString("activeDirectoryRealm.unparseableName", new Object[]{absoluteName}));
        }
    }

    protected Name getRelativeName(DirContext context, String distinguishedName) throws NamingException {
        Rdn nameInNamespaceRdn;
        Rdn nameRdn;
        NameParser parser = context.getNameParser("");
        LdapName nameInNamespace = (LdapName)parser.parse(context.getNameInNamespace());
        LdapName name = (LdapName)parser.parse(distinguishedName);
        while (Math.min(name.size(), nameInNamespace.size()) != 0 && (nameRdn = name.getRdn(0)).equals(nameInNamespaceRdn = nameInNamespace.getRdn(0))) {
            name.remove(0);
            nameInNamespace.remove(0);
        }
        while (Math.min(name.size(), nameInNamespace.size()) != 0) {
            int innerPosn = nameInNamespace.size() - 1;
            nameRdn = name.getRdn(0);
            if (!nameRdn.equals(nameInNamespaceRdn = nameInNamespace.getRdn(innerPosn))) break;
            name.remove(0);
            nameInNamespace.remove(innerPosn);
        }
        return name;
    }

    static {
        X500_PRINCIPAL_OID_MAP = new HashMap<String, String>();
        USERNAME_SEARCH_MAPPERS = new UsernameSearchMapper[]{new SamAccountNameRfc2247Mapper(), new UserPrincipalNameSearchMapper()};
        DEFAULT_USER_ATTRIBUTES = new String[]{"userAccountControl", "memberOf", "objectSid;binary", "sAMAccountName"};
        DEFAULT_ROLE_ATTRIBUTES = new String[]{"groupType"};
        ROLE_FORMAT_ATTRIBUTES = new HashMap<String, String[]>();
        try {
            MS_UPN = new Oid("1.3.6.1.4.1.311.20.2.3");
        }
        catch (GSSException e) {
            throw new IllegalStateException("Failed to create OID for MS_UPN");
        }
        try {
            KRB5_NT_PRINCIPAL = new Oid("1.2.840.113554.1.2.2.1");
        }
        catch (GSSException e) {
            throw new IllegalStateException("Failed to create OID for KRB5_NT_PRINCIPAL");
        }
        X500_PRINCIPAL_OID_MAP.put("1.2.840.113549.1.9.1", "emailAddress");
        X500_PRINCIPAL_OID_MAP.put("2.5.4.5", "serialNumber");
        X500_PRINCIPAL_OID_MAP.put("2.5.4.4", "SN");
        X500_PRINCIPAL_OID_MAP.put("2.5.4.42", "GN");
        ROLE_FORMAT_ATTRIBUTES.put(DEFAULT_ROLE_FORMAT, new String[]{"objectSid;binary", "sIDHistory;binary"});
        ROLE_FORMAT_ATTRIBUTES.put("name", new String[]{"msDS-PrincipalName"});
        ROLE_FORMAT_ATTRIBUTES.put("nameEx", new String[]{"distinguishedName", "sAMAccountName"});
    }

    protected static class User {
        private final GSSName gssName;
        private final Sid sid;
        private final List<String> roles;
        private final Map<String, Object> additionalAttributes;

        public User(GSSName gssName, Sid sid, List<String> roles, Map<String, Object> additionalAttributes) {
            this.gssName = gssName;
            this.sid = sid;
            this.roles = roles;
            this.additionalAttributes = additionalAttributes;
        }

        public GSSName getGssName() {
            return this.gssName;
        }

        public Sid getSid() {
            return this.sid;
        }

        public List<String> getRoles() {
            return this.roles;
        }

        public Map<String, Object> getAdditionalAttributes() {
            return this.additionalAttributes;
        }
    }

    protected static class DirContextConnection {
        protected String id;
        protected long lastBorrowTime;
        protected DirContext context;

        protected DirContextConnection() {
        }
    }
}

