/*
 * Decompiled with CFR 0.152.
 */
package net.sf.michaelo.tomcat.realm.asn1;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateParsingException;
import java.util.Objects;
import net.sf.michaelo.tomcat.realm.asn1.OtherNameParseResult;

public class OtherNameAsn1Parser {
    private static byte CONTEXT_SPECIFIC_BIT = (byte)7;
    private static byte CONSTRUCTED_BIT = (byte)5;
    private static byte MAX_SINGLE_BYTE_LENGTH = (byte)127;
    private static byte SEQUENCE_TAG = (byte)48;
    private static byte OID_TAG = (byte)6;
    private static byte UTF8STRING_TAG = (byte)12;

    private OtherNameAsn1Parser() {
    }

    public static OtherNameParseResult parse(byte[] otherName) throws CertificateParsingException {
        Objects.requireNonNull(otherName, "otherName cannot be null");
        ByteBuffer buf = ByteBuffer.wrap(otherName);
        if (!buf.hasRemaining()) {
            throw new CertificateParsingException("otherName type tag not available, buffer is empty");
        }
        byte tag = buf.get();
        if (tag != SEQUENCE_TAG) {
            throw new CertificateParsingException(String.format("otherName must start with a SEQUENCE tag, but starts with 0x%02x", tag));
        }
        int seqLen = OtherNameAsn1Parser.parseLength(buf);
        if (seqLen > buf.remaining()) {
            throw new CertificateParsingException(String.format("SEQUENCE length (%s B) is larger than the buffer offers (%s B)", seqLen, buf.remaining()));
        }
        int limit = buf.position() + seqLen;
        buf.limit(limit);
        if (!buf.hasRemaining()) {
            throw new CertificateParsingException("otherName fields not available, buffer is empty");
        }
        byte[] typeId = OtherNameAsn1Parser.parseOid(buf);
        byte[] value = OtherNameAsn1Parser.parseValue(buf);
        return new OtherNameParseResult(typeId, value);
    }

    public static String parseUtf8String(byte[] string) throws CertificateParsingException {
        Objects.requireNonNull(string, "string cannot be null");
        ByteBuffer buf = ByteBuffer.wrap(string);
        if (!buf.hasRemaining()) {
            throw new CertificateParsingException("string type tag not available, buffer is empty");
        }
        byte tag = buf.get();
        if (tag != UTF8STRING_TAG) {
            throw new CertificateParsingException(String.format("string must start with a UTF8String tag, but starts with 0x%02x", tag));
        }
        int strLen = OtherNameAsn1Parser.parseLength(buf);
        if (strLen > buf.remaining()) {
            throw new CertificateParsingException(String.format("UTF8String length (%s B) is larger than the buffer offers (%s B)", strLen, buf.remaining()));
        }
        byte[] str = new byte[strLen];
        buf.get(str);
        return new String(str, StandardCharsets.UTF_8);
    }

    private static int parseLength(ByteBuffer buf) throws CertificateParsingException {
        if (!buf.hasRemaining()) {
            throw new CertificateParsingException("Type length not available, buffer is empty");
        }
        int typeLen = buf.get() & 0xFF;
        if (typeLen <= MAX_SINGLE_BYTE_LENGTH) {
            return typeLen;
        }
        int n = typeLen & MAX_SINGLE_BYTE_LENGTH;
        if (n == 0) {
            throw new CertificateParsingException("Indefinite type length is not supported");
        }
        if (n > 2) {
            throw new CertificateParsingException("Type length above 64 KiB ist not supported");
        }
        if (n > buf.remaining()) {
            throw new CertificateParsingException(String.format("Type length bytes (%s B) are larger than the buffer offers (%s B)", n, buf.remaining()));
        }
        typeLen = 0;
        for (int i = 0; i < n; ++i) {
            typeLen = typeLen << 8 | buf.get() & 0xFF;
        }
        return typeLen;
    }

    private static byte[] parseOid(ByteBuffer buf) throws CertificateParsingException {
        if (!buf.hasRemaining()) {
            throw new CertificateParsingException("OID type tag not available, buffer is empty");
        }
        byte tag = buf.get();
        if (tag != OID_TAG) {
            throw new CertificateParsingException(String.format("OID must start with an OBJECT IDENTIFIER tag, but is 0x%02x", tag));
        }
        int oidLen = OtherNameAsn1Parser.parseLength(buf);
        if (oidLen > buf.remaining()) {
            throw new CertificateParsingException(String.format("OBJECT IDENTIFIER length (%s B) is larger than the buffer offers (%s B)", oidLen, buf.remaining()));
        }
        if (!buf.hasRemaining()) {
            throw new CertificateParsingException("OID value not available, buffer is empty");
        }
        byte[] oid = new byte[oidLen];
        buf.get(oid);
        return oid;
    }

    private static byte[] parseValue(ByteBuffer buf) throws CertificateParsingException {
        if (!buf.hasRemaining()) {
            throw new CertificateParsingException("Value type tag not available, buffer is empty");
        }
        byte tag = buf.get();
        if ((tag >> CONTEXT_SPECIFIC_BIT & 1) == 0 || (tag >> CONSTRUCTED_BIT & 1) == 0) {
            throw new CertificateParsingException("Value must be explicitly encoded");
        }
        int tagNumber = tag & 0xFF;
        tagNumber &= ~(1 << CONTEXT_SPECIFIC_BIT);
        if ((tagNumber &= ~(1 << CONSTRUCTED_BIT)) != 0) {
            throw new CertificateParsingException("Value tag number must be 0, but is " + tagNumber);
        }
        int valLen = OtherNameAsn1Parser.parseLength(buf);
        if (valLen > buf.remaining()) {
            throw new CertificateParsingException(String.format("Value length (%s B) is larger than the buffer offers (%s B)", valLen, buf.remaining()));
        }
        int limit = buf.position() + valLen;
        buf.limit(limit);
        if (!buf.hasRemaining()) {
            throw new CertificateParsingException("Value not available, buffer is empty");
        }
        int pos = buf.position();
        tag = buf.get();
        tagNumber = tag & 0xFF;
        tagNumber &= ~(1 << CONTEXT_SPECIFIC_BIT);
        if ((tag >> CONTEXT_SPECIFIC_BIT & 1) != 0 && (tag >> CONSTRUCTED_BIT & 1) != 0 && (tagNumber &= ~(1 << CONSTRUCTED_BIT)) == 0) {
            valLen = OtherNameAsn1Parser.parseLength(buf);
            if (valLen > buf.remaining()) {
                throw new CertificateParsingException(String.format("Value length (%s B) is larger than the buffer offers (%s B)", valLen, buf.remaining()));
            }
            limit = buf.position() + valLen;
            buf.limit(limit);
        } else {
            buf.position(pos);
        }
        if (!buf.hasRemaining()) {
            throw new CertificateParsingException("Value not available, buffer is empty");
        }
        byte[] value = new byte[valLen];
        buf.get(value);
        return value;
    }
}

