/*
 * Decompiled with CFR 0.152.
 */
package net.sf.michaelo.tomcat.realm;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class Sid {
    public static final Sid NULL_SID = new Sid(new byte[]{1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    public static final Sid ANONYMOUS_SID = new Sid(new byte[]{1, 1, 0, 0, 0, 0, 0, 5, 7, 0, 0, 0});
    private byte[] bytes;
    private int revision;
    private int subAuthorityCount;
    private byte[] identifierAuthority;
    private long[] subAuthorities;
    private String sidString;

    public Sid(byte[] sid) {
        if (sid == null) {
            throw new NullPointerException("SID cannot be null");
        }
        if (sid.length < 12) {
            throw new IllegalArgumentException("SID must be at least 12 bytes long but is " + sid.length);
        }
        this.bytes = Arrays.copyOf(sid, sid.length);
        ByteBuffer bb = ByteBuffer.wrap(this.bytes);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        this.revision = bb.get() & 0xFF;
        if (this.revision != 1) {
            throw new IllegalArgumentException("SID revision must be 1 but is " + this.revision);
        }
        this.subAuthorityCount = bb.get() & 0xFF;
        if (this.subAuthorityCount > 15) {
            throw new IllegalArgumentException("SID sub authority count must be at most 15 but is " + this.subAuthorityCount);
        }
        this.identifierAuthority = new byte[6];
        bb.get(this.identifierAuthority);
        StringBuilder sidStringBuilder = new StringBuilder("S");
        sidStringBuilder.append('-').append(this.revision);
        ByteBuffer iaBb = ByteBuffer.allocate(8);
        iaBb.position(2);
        iaBb.put(this.identifierAuthority);
        iaBb.flip();
        sidStringBuilder.append('-').append(iaBb.getLong());
        this.subAuthorities = new long[this.subAuthorityCount];
        for (int b = 0; b < this.subAuthorityCount; b = (int)((byte)(b + 1))) {
            this.subAuthorities[b] = (long)bb.getInt() & 0xFFFFFFFFL;
            sidStringBuilder.append('-').append(this.subAuthorities[b]);
        }
        this.sidString = sidStringBuilder.toString();
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Sid)) {
            return false;
        }
        Sid that = (Sid)obj;
        if (this == that) {
            return true;
        }
        return Arrays.equals(this.bytes, that.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public String toString() {
        return this.sidString;
    }
}

