/*
 * Decompiled with CFR 0.152.
 */
package net.sf.michaelo.tomcat.realm;

import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sf.michaelo.tomcat.realm.Sid;
import org.apache.catalina.TomcatPrincipal;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSName;

public class ActiveDirectoryPrincipal
implements TomcatPrincipal {
    private final GSSName gssName;
    private final Sid sid;
    private final transient GSSCredential gssCredential;
    private final String[] roles;
    private final Map<String, Object> additionalAttributes;

    public ActiveDirectoryPrincipal(GSSName gssName, Sid sid, GSSCredential gssCredential) {
        this(gssName, sid, null, gssCredential, null);
    }

    public ActiveDirectoryPrincipal(GSSName gssName, Sid sid, List<String> roles, GSSCredential gssCredential, Map<String, Object> additionalAttributes) {
        this.gssName = gssName;
        this.sid = sid;
        if (roles == null || roles.isEmpty()) {
            this.roles = new String[0];
        } else {
            this.roles = roles.toArray(new String[0]);
            Arrays.sort(this.roles);
        }
        this.gssCredential = gssCredential;
        this.additionalAttributes = additionalAttributes == null || additionalAttributes.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(additionalAttributes);
    }

    public Principal getUserPrincipal() {
        return this;
    }

    public String getName() {
        return this.gssName.toString();
    }

    public GSSName getGssName() {
        return this.gssName;
    }

    public Sid getSid() {
        return this.sid;
    }

    public GSSCredential getGssCredential() {
        return this.gssCredential;
    }

    public boolean hasRole(String role) {
        if ("*".equals(role)) {
            return true;
        }
        if (role == null) {
            return false;
        }
        return Arrays.binarySearch(this.roles, role) >= 0;
    }

    public String[] getRoles() {
        return Arrays.copyOf(this.roles, this.roles.length);
    }

    public Map<String, Object> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActiveDirectoryPrincipal)) {
            return false;
        }
        ActiveDirectoryPrincipal other = (ActiveDirectoryPrincipal)obj;
        return this.gssName.equals((Object)other.gssName);
    }

    public int hashCode() {
        return this.gssName.hashCode();
    }

    public String toString() {
        return this.gssName.toString();
    }

    public void logout() throws Exception {
        if (this.gssCredential != null) {
            this.gssCredential.dispose();
        }
    }
}

