/*
 * Decompiled with CFR 0.152.
 */
package net.sf.michaelo.tomcat.authenticator;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import net.sf.michaelo.tomcat.internal.org.apache.commons.lang3.StringUtils;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Request;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

abstract class GSSAuthenticatorBase
extends AuthenticatorBase {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected final StringManager sm = StringManager.getManager(((Object)((Object)this)).getClass());
    protected static final Oid KRB5_MECHANISM;
    protected static final Oid SPNEGO_MECHANISM;
    private String loginEntryName;
    private boolean omitErrorMessages;
    private boolean errorMessagesAsHeaders;
    private boolean storeDelegatedCredential;

    GSSAuthenticatorBase() {
    }

    public void setLoginEntryName(String loginEntryName) {
        this.loginEntryName = loginEntryName;
    }

    public String getLoginEntryName() {
        return this.loginEntryName;
    }

    public boolean isOmitErrorMessages() {
        return this.omitErrorMessages;
    }

    public void setOmitErrorMessages(boolean omitErrorMessages) {
        this.omitErrorMessages = omitErrorMessages;
    }

    public boolean isErrorMessagesAsHeaders() {
        return this.errorMessagesAsHeaders;
    }

    public void setErrorMessagesAsHeaders(boolean errorMessagesAsHeaders) {
        this.errorMessagesAsHeaders = errorMessagesAsHeaders;
    }

    public boolean isStoreDelegatedCredential() {
        return this.storeDelegatedCredential;
    }

    public void setStoreDelegatedCredential(boolean storeDelegatedCredential) {
        this.storeDelegatedCredential = storeDelegatedCredential;
    }

    protected void respondErrorMessage(Request request, HttpServletResponse response, int statusCode, String messageKey, Object ... params) throws IOException {
        String message = null;
        if (!this.omitErrorMessages && StringUtils.isNotEmpty(messageKey)) {
            message = this.sm.getString(messageKey, params);
        }
        if (this.errorMessagesAsHeaders) {
            if (StringUtils.isNotEmpty(message)) {
                String headerName;
                switch (statusCode) {
                    case 401: {
                        headerName = "Auth-Error";
                        break;
                    }
                    case 500: {
                        headerName = "Server-Error";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("Status code %s not supported", statusCode));
                    }
                }
                response.setHeader(headerName, message);
            }
            response.setStatus(statusCode);
        } else {
            response.sendError(statusCode, message);
        }
    }

    protected void sendInternalServerError(Request request, HttpServletResponse response, String messageKey, Object ... params) throws IOException {
        this.respondErrorMessage(request, response, 500, messageKey, params);
    }

    protected void sendUnauthorized(Request request, HttpServletResponse response, String scheme) throws IOException {
        this.sendUnauthorized(request, response, scheme, null, new Object[0]);
    }

    protected void sendUnauthorized(Request request, HttpServletResponse response, String scheme, String messageKey, Object ... params) throws IOException {
        response.addHeader("WWW-Authenticate", scheme);
        this.respondErrorMessage(request, response, 401, messageKey, params);
    }

    static {
        try {
            KRB5_MECHANISM = new Oid("1.2.840.113554.1.2.2");
        }
        catch (GSSException e) {
            throw new IllegalStateException("Failed to create OID for Kerberos 5 mechanism");
        }
        try {
            SPNEGO_MECHANISM = new Oid("1.3.6.1.5.5.2");
        }
        catch (GSSException e) {
            throw new IllegalStateException("Failed to create OID for SPNEGO mechanism");
        }
    }
}

