/*
 * Decompiled with CFR 0.152.
 */
package mulan.transformations;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import mulan.data.LabelSet;
import mulan.data.MultiLabelInstances;
import mulan.transformations.RemoveAllLabels;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;

public class LabelPowersetTransformation
implements Serializable {
    private Instances transformedFormat;

    public Instances getTransformedFormat() {
        return this.transformedFormat;
    }

    public Instances transformInstances(MultiLabelInstances mlData) throws Exception {
        Instances data = mlData.getDataSet();
        int numLabels = mlData.getNumLabels();
        int[] labelIndices = mlData.getLabelIndices();
        Instances newData = null;
        HashSet<LabelSet> labelSets = new HashSet<LabelSet>();
        int numInstances = data.numInstances();
        for (int i = 0; i < numInstances; ++i) {
            double[] dblLabels = new double[numLabels];
            for (int j = 0; j < numLabels; ++j) {
                int index = labelIndices[j];
                dblLabels[j] = Double.parseDouble(data.attribute(index).value((int)data.instance(i).value(index)));
            }
            LabelSet labelSet = new LabelSet(dblLabels);
            labelSets.add(labelSet);
        }
        ArrayList<String> classValues = new ArrayList<String>(labelSets.size());
        for (LabelSet subset : labelSets) {
            classValues.add(subset.toBitString());
        }
        Attribute newClass = new Attribute("class", classValues);
        newData = RemoveAllLabels.transformInstances(data, labelIndices);
        newData.insertAttributeAt(newClass, newData.numAttributes());
        newData.setClassIndex(newData.numAttributes() - 1);
        for (int i = 0; i < newData.numInstances(); ++i) {
            String strClass = "";
            for (int j = 0; j < numLabels; ++j) {
                int index = labelIndices[j];
                strClass = strClass + data.attribute(index).value((int)data.instance(i).value(index));
            }
            newData.instance(i).setClassValue(strClass);
        }
        this.transformedFormat = new Instances(newData, 0);
        return newData;
    }

    public Instance transformInstance(Instance instance, int[] labelIndices) throws Exception {
        Instance transformedInstance = RemoveAllLabels.transformInstance(instance, labelIndices);
        transformedInstance.setDataset(null);
        transformedInstance.insertAttributeAt(transformedInstance.numAttributes());
        transformedInstance.setDataset(this.transformedFormat);
        return transformedInstance;
    }
}

