/*
 * Decompiled with CFR 0.152.
 */
package mulan.transformations;

import java.io.Serializable;
import java.util.ArrayList;
import mulan.data.MultiLabelInstances;
import mulan.transformations.RemoveAllLabels;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;

public class IncludeLabelsTransformation
implements Serializable {
    private int[] labelIndices;

    public Instances transformInstances(MultiLabelInstances mlData) throws Exception {
        int numLabels = mlData.getNumLabels();
        this.labelIndices = mlData.getLabelIndices();
        Instances transformed = RemoveAllLabels.transformInstances(mlData);
        ArrayList<String> labelNames = new ArrayList<String>(numLabels);
        for (int counter = 0; counter < numLabels; ++counter) {
            labelNames.add(mlData.getDataSet().attribute(this.labelIndices[counter]).name());
        }
        Attribute attrLabel = new Attribute("Label", labelNames);
        transformed.insertAttributeAt(attrLabel, transformed.numAttributes());
        ArrayList<String> binaryValues = new ArrayList<String>(2);
        binaryValues.add("0");
        binaryValues.add("1");
        Attribute classAttr = new Attribute("Class", binaryValues);
        transformed.insertAttributeAt(classAttr, transformed.numAttributes());
        transformed = new Instances(transformed, 0);
        transformed.setClassIndex(transformed.numAttributes() - 1);
        Instances data = mlData.getDataSet();
        for (int instanceIndex = 0; instanceIndex < data.numInstances(); ++instanceIndex) {
            for (int labelCounter = 0; labelCounter < numLabels; ++labelCounter) {
                Instance temp = RemoveAllLabels.transformInstance(data.instance(instanceIndex), this.labelIndices);
                temp.setDataset(null);
                temp.insertAttributeAt(temp.numAttributes());
                temp.insertAttributeAt(temp.numAttributes());
                temp.setDataset(transformed);
                temp.setValue(temp.numAttributes() - 2, (String)labelNames.get(labelCounter));
                if (data.attribute(this.labelIndices[labelCounter]).value((int)data.instance(instanceIndex).value(this.labelIndices[labelCounter])).equals("1")) {
                    temp.setValue(temp.numAttributes() - 1, "1");
                } else {
                    temp.setValue(temp.numAttributes() - 1, "0");
                }
                transformed.add(temp);
            }
        }
        return transformed;
    }

    public Instance transformInstance(Instance instance) throws Exception {
        if (this.labelIndices == null) {
            System.out.println("Label Indices not set!!");
            return null;
        }
        Instance transformedInstance = RemoveAllLabels.transformInstance(instance, this.labelIndices);
        transformedInstance.setDataset(null);
        transformedInstance.insertAttributeAt(transformedInstance.numAttributes());
        transformedInstance.insertAttributeAt(transformedInstance.numAttributes());
        return transformedInstance;
    }
}

