/*
 * Decompiled with CFR 0.152.
 */
package mulan.experiments;

import java.util.ArrayList;
import java.util.Random;
import mulan.classifier.lazy.IBLR_ML;
import mulan.data.MultiLabelInstances;
import mulan.evaluation.Evaluation;
import mulan.evaluation.Evaluator;
import mulan.evaluation.MultipleEvaluation;
import mulan.evaluation.measure.AveragePrecision;
import mulan.evaluation.measure.Coverage;
import mulan.evaluation.measure.HammingLoss;
import mulan.evaluation.measure.Measure;
import mulan.evaluation.measure.OneError;
import mulan.evaluation.measure.RankingLoss;
import mulan.experiments.Experiment;
import weka.core.Instances;
import weka.core.TechnicalInformation;
import weka.core.Utils;

public class MachineLearning09IBLR
extends Experiment {
    public static void main(String[] args) {
        try {
            String path = Utils.getOption((String)"path", (String[])args);
            String filestem = Utils.getOption((String)"filestem", (String[])args);
            System.out.println("Loading the data set");
            MultiLabelInstances dataSet = new MultiLabelInstances(path + filestem + ".arff", path + filestem + ".xml");
            Evaluator evaluator = new Evaluator();
            ArrayList<Measure> measures = new ArrayList<Measure>(5);
            measures.add(new HammingLoss());
            measures.add(new OneError());
            measures.add(new Coverage());
            measures.add(new RankingLoss());
            measures.add(new AveragePrecision());
            MultipleEvaluation iblrmlResults = new MultipleEvaluation(dataSet);
            MultipleEvaluation iblrmlPlusResults = new MultipleEvaluation(dataSet);
            Random random = new Random(1L);
            for (int repetition = 0; repetition < 10; ++repetition) {
                dataSet.getDataSet().randomize(random);
                for (int fold = 0; fold < 10; ++fold) {
                    System.out.println("Experiment " + (repetition * 10 + fold + 1));
                    Instances train = dataSet.getDataSet().trainCV(10, fold);
                    MultiLabelInstances multiTrain = new MultiLabelInstances(train, dataSet.getLabelsMetaData());
                    Instances test = dataSet.getDataSet().testCV(10, fold);
                    MultiLabelInstances multiTest = new MultiLabelInstances(test, dataSet.getLabelsMetaData());
                    System.out.println("IBLR-ML Experiment");
                    IBLR_ML iblrml = new IBLR_ML();
                    iblrml.build(multiTrain);
                    evaluator = new Evaluator();
                    Evaluation e1 = evaluator.evaluate(iblrml, multiTest, measures);
                    System.out.println(e1.toCSV());
                    iblrmlResults.addEvaluation(e1);
                    System.out.println("IBLR-ML+ Experiment");
                    IBLR_ML iblrmlplus = new IBLR_ML(10, true);
                    iblrmlplus.build(multiTrain);
                    evaluator = new Evaluator();
                    Evaluation e2 = evaluator.evaluate(iblrmlplus, multiTest, measures);
                    System.out.println(e2.toCSV());
                    iblrmlPlusResults.addEvaluation(e2);
                }
            }
            iblrmlResults.calculateStatistics();
            System.out.println(iblrmlResults);
            iblrmlPlusResults.calculateStatistics();
            System.out.println(iblrmlPlusResults);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Weiwei Cheng and Eyke Hullermeier");
        result.setValue(TechnicalInformation.Field.TITLE, "Combining instance-based learning and logistic regression for multilabel classification ");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning");
        result.setValue(TechnicalInformation.Field.VOLUME, "76");
        result.setValue(TechnicalInformation.Field.NUMBER, "2-3");
        result.setValue(TechnicalInformation.Field.YEAR, "2009");
        result.setValue(TechnicalInformation.Field.ISSN, "0885-6125");
        result.setValue(TechnicalInformation.Field.PAGES, "211-225");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Springer Netherlands");
        return result;
    }
}

