/*
 * Decompiled with CFR 0.152.
 */
package mulan.experiments;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import mulan.classifier.MultiLabelLearner;
import mulan.classifier.lazy.MLkNN;
import mulan.classifier.meta.thresholding.MetaLabeler;
import mulan.classifier.meta.thresholding.OneThreshold;
import mulan.classifier.meta.thresholding.RCut;
import mulan.classifier.meta.thresholding.SCut;
import mulan.classifier.meta.thresholding.ThresholdPrediction;
import mulan.classifier.neural.BPMLL;
import mulan.classifier.transformation.BinaryRelevance;
import mulan.classifier.transformation.CalibratedLabelRanking;
import mulan.data.MultiLabelInstances;
import mulan.evaluation.Evaluator;
import mulan.evaluation.MultipleEvaluation;
import mulan.evaluation.measure.HammingLoss;
import mulan.evaluation.measure.Measure;
import mulan.experiments.Experiment;
import weka.classifiers.Classifier;
import weka.classifiers.meta.Bagging;
import weka.classifiers.trees.J48;
import weka.classifiers.trees.M5P;
import weka.core.TechnicalInformation;
import weka.core.Utils;

public class ICTAI2010
extends Experiment {
    public static void main(String[] args) {
        try {
            String path = Utils.getOption((String)"path", (String[])args);
            String filestem = Utils.getOption((String)"filestem", (String[])args);
            System.out.println("Loading the data set");
            MultiLabelInstances dataset = new MultiLabelInstances(path + filestem + ".arff", path + filestem + ".xml");
            Evaluator eval = new Evaluator();
            ArrayList<Measure> measures = new ArrayList<Measure>(1);
            measures.add(new HammingLoss());
            int numFolds = 10;
            MultiLabelLearner[] learner = new MultiLabelLearner[4];
            String[] learnerName = new String[learner.length];
            learner[0] = new MLkNN(10, 1.0);
            learnerName[0] = "MLkNN";
            learner[1] = new CalibratedLabelRanking((Classifier)new J48());
            learnerName[1] = "CLR";
            Bagging bagging = new Bagging();
            bagging.setClassifier((Classifier)new J48());
            learner[2] = new BinaryRelevance((Classifier)bagging);
            learnerName[2] = "BR";
            learner[3] = new BPMLL();
            learnerName[3] = "BPMLL";
            for (int i = 0; i < learner.length; ++i) {
                MultipleEvaluation results = eval.crossValidate(learner[i].makeCopy(), dataset, measures, numFolds);
                System.out.println(learnerName[i] + ";default;-;" + results.toCSV());
                OneThreshold ot = new OneThreshold(learner[i].makeCopy(), new HammingLoss());
                results = eval.crossValidate(ot, dataset, measures, numFolds);
                System.out.println(learnerName[i] + ";one threshold;train;" + results.toCSV());
                ot = new OneThreshold(learner[i].makeCopy(), new HammingLoss(), 5);
                results = eval.crossValidate(ot, dataset, measures, numFolds);
                System.out.println(learnerName[i] + ";one threshold;5-cv;" + results.toCSV());
                RCut rcut = new RCut(learner[i].makeCopy());
                results = eval.crossValidate(rcut, dataset, measures, numFolds);
                System.out.println(learnerName[i] + ";rcut;cardinality;" + results.toCSV());
                rcut = new RCut(learner[i].makeCopy(), new HammingLoss());
                results = eval.crossValidate(rcut, dataset, measures, numFolds);
                System.out.println(learnerName[i] + ";rcut;train;" + results.toCSV());
                rcut = new RCut(learner[i].makeCopy(), new HammingLoss(), 5);
                results = eval.crossValidate(rcut, dataset, measures, numFolds);
                System.out.println(learnerName[i] + ";rcut;5-cv;" + results.toCSV());
                SCut scut = new SCut(learner[i].makeCopy(), new HammingLoss());
                results = eval.crossValidate(scut, dataset, measures, numFolds);
                System.out.println(learnerName[i] + ";scut;train;" + results.toCSV());
                scut = new SCut(learner[i].makeCopy(), new HammingLoss(), 5);
                results = eval.crossValidate(scut, dataset, measures, numFolds);
                System.out.println(learnerName[i] + ";scut;5-cv;" + results.toCSV());
                MetaLabeler ml = new MetaLabeler(learner[i].makeCopy(), (Classifier)new M5P(), "Content-Based", "Numeric-Class");
                ml.setFolds(1);
                results = eval.crossValidate(ml, dataset, measures, numFolds);
                System.out.println(learnerName[i] + ";metalabeler;m5p;train;content;" + results.toCSV());
                ml = new MetaLabeler(learner[i].makeCopy(), (Classifier)new M5P(), "Score-Based", "Numeric-Class");
                ml.setFolds(1);
                results = eval.crossValidate(ml, dataset, measures, numFolds);
                System.out.println(learnerName[i] + ";metalabeler;m5p;train;scores;" + results.toCSV());
                ml = new MetaLabeler(learner[i].makeCopy(), (Classifier)new M5P(), "Rank-Based", "Numeric-Class");
                ml.setFolds(1);
                results = eval.crossValidate(ml, dataset, measures, numFolds);
                System.out.println(learnerName[i] + ";metalabeler;m5p;train;ranks;" + results.toCSV());
                ml = new MetaLabeler(learner[i].makeCopy(), (Classifier)new J48(), "Content-Based", "Nominal-Class");
                ml.setFolds(1);
                results = eval.crossValidate(ml, dataset, measures, numFolds);
                System.out.println(learnerName[i] + ";metalabeler;j48;train;content;" + results.toCSV());
                ml = new MetaLabeler(learner[i].makeCopy(), (Classifier)new J48(), "Score-Based", "Nominal-Class");
                ml.setFolds(1);
                results = eval.crossValidate(ml, dataset, measures, numFolds);
                System.out.println(learnerName[i] + ";metalabeler;j48;train;scores;" + results.toCSV());
                ml = new MetaLabeler(learner[i].makeCopy(), (Classifier)new J48(), "Rank-Based", "Nominal-Class");
                ml.setFolds(1);
                results = eval.crossValidate(ml, dataset, measures, numFolds);
                System.out.println(learnerName[i] + ";metalabeler;j48;cv;ranks;" + results.toCSV());
                ml = new MetaLabeler(learner[i].makeCopy(), (Classifier)new M5P(), "Content-Based", "Numeric-Class");
                ml.setFolds(5);
                results = eval.crossValidate(ml, dataset, measures, numFolds);
                System.out.println(learnerName[i] + ";metalabeler;m5p;cv;content;" + results.toCSV());
                ml = new MetaLabeler(learner[i].makeCopy(), (Classifier)new M5P(), "Score-Based", "Numeric-Class");
                ml.setFolds(5);
                results = eval.crossValidate(ml, dataset, measures, numFolds);
                System.out.println(learnerName[i] + ";metalabeler;m5p;cv;scores;" + results.toCSV());
                ml = new MetaLabeler(learner[i].makeCopy(), (Classifier)new M5P(), "Rank-Based", "Numeric-Class");
                ml.setFolds(5);
                results = eval.crossValidate(ml, dataset, measures, numFolds);
                System.out.println(learnerName[i] + ";metalabeler;m5p;cv;ranks;" + results.toCSV());
                ml = new MetaLabeler(learner[i].makeCopy(), (Classifier)new J48(), "Content-Based", "Nominal-Class");
                ml.setFolds(5);
                results = eval.crossValidate(ml, dataset, measures, numFolds);
                System.out.println(learnerName[i] + ";metalabeler;j48;cv;content;" + results.toCSV());
                ml = new MetaLabeler(learner[i].makeCopy(), (Classifier)new J48(), "Score-Based", "Nominal-Class");
                ml.setFolds(5);
                results = eval.crossValidate(ml, dataset, measures, numFolds);
                System.out.println(learnerName[i] + ";metalabeler;j48;cv;scores;" + results.toCSV());
                ml = new MetaLabeler(learner[i].makeCopy(), (Classifier)new J48(), "Rank-Based", "Nominal-Class");
                ml.setFolds(5);
                results = eval.crossValidate(ml, dataset, measures, numFolds);
                System.out.println(learnerName[i] + ";metalabeler;j48;cv;ranks;" + results.toCSV());
                ThresholdPrediction tp = new ThresholdPrediction(learner[i].makeCopy(), (Classifier)new M5P(), "Content-Based", 1);
                results = eval.crossValidate(tp, dataset, measures, numFolds);
                System.out.println(learnerName[i] + ";tp;m5p;train;content;" + results.toCSV());
                tp = new ThresholdPrediction(learner[i].makeCopy(), (Classifier)new M5P(), "Score-Based", 1);
                results = eval.crossValidate(tp, dataset, measures, numFolds);
                System.out.println(learnerName[i] + ";tp;m5p;train;scores;" + results.toCSV());
                tp = new ThresholdPrediction(learner[i].makeCopy(), (Classifier)new M5P(), "Rank-Based", 1);
                results = eval.crossValidate(tp, dataset, measures, numFolds);
                System.out.println(learnerName[i] + ";tp;m5p;train;ranks;" + results.toCSV());
                tp = new ThresholdPrediction(learner[i].makeCopy(), (Classifier)new M5P(), "Content-Based", 5);
                results = eval.crossValidate(tp, dataset, measures, numFolds);
                System.out.println(learnerName[i] + ";tp;m5p;5-cv;content;" + results.toCSV());
                tp = new ThresholdPrediction(learner[i].makeCopy(), (Classifier)new M5P(), "Score-Based", 5);
                results = eval.crossValidate(tp, dataset, measures, numFolds);
                System.out.println(learnerName[i] + ";tp;m5p;5-cv;scores;" + results.toCSV());
                tp = new ThresholdPrediction(learner[i].makeCopy(), (Classifier)new M5P(), "Rank-Based", 5);
                results = eval.crossValidate(tp, dataset, measures, numFolds);
                System.out.println(learnerName[i] + ";tp;m5p;5-cv;ranks;" + results.toCSV());
            }
        }
        catch (Exception ex) {
            Logger.getLogger(ICTAI2010.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Marios Ioannou and George Sakkas and Grigorios Tsoumakas and Ioannis Vlahavas");
        result.setValue(TechnicalInformation.Field.TITLE, "Obtaining Bipartitions from Score Vectors for Multi-Label Classification");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Proceedings of the 22th IEEE International Conference on Tools with Artificial Intelligence");
        result.setValue(TechnicalInformation.Field.YEAR, "2010");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "IEEE");
        return result;
    }
}

