/*
 * Decompiled with CFR 0.152.
 */
package mulan.examples;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import mulan.classifier.MultiLabelOutput;
import mulan.classifier.meta.RAkEL;
import mulan.classifier.transformation.LabelPowerset;
import mulan.data.InvalidDataFormatException;
import mulan.data.MultiLabelInstances;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;
import weka.core.Instance;
import weka.core.Utils;

public class GettingPredictionsOnUnlabeledData {
    public static void main(String[] args) {
        try {
            String arffFilename = Utils.getOption((String)"arff", (String[])args);
            String xmlFilename = Utils.getOption((String)"xml", (String[])args);
            System.out.println("Loading the training data set...");
            MultiLabelInstances trainingData = new MultiLabelInstances(arffFilename, xmlFilename);
            RAkEL model = new RAkEL(new LabelPowerset((Classifier)new J48()));
            System.out.println("Building the model...");
            model.build(trainingData);
            model.setSizeOfSubset(2);
            String unlabeledDataFilename = Utils.getOption((String)"unlabeled", (String[])args);
            System.out.println("Loading the unlabeled data set...");
            MultiLabelInstances unlabeledData = new MultiLabelInstances(unlabeledDataFilename, xmlFilename);
            int numInstances = unlabeledData.getNumInstances();
            for (int instanceIndex = 0; instanceIndex < numInstances; ++instanceIndex) {
                Instance instance = unlabeledData.getDataSet().instance(instanceIndex);
                MultiLabelOutput output = model.makePrediction(instance);
                if (!output.hasBipartition()) continue;
                String bipartion = Arrays.toString(output.getBipartition());
                System.out.println("Predicted bipartion: " + bipartion);
            }
        }
        catch (InvalidDataFormatException e) {
            System.err.println(e.getMessage());
        }
        catch (Exception ex) {
            Logger.getLogger(GettingPredictionsOnUnlabeledData.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

