/*
 * Decompiled with CFR 0.152.
 */
package mulan.evaluation.measure;

import mulan.classifier.MultiLabelOutput;
import mulan.core.ArgumentNullException;
import mulan.evaluation.measure.MeasureBase;

public abstract class RankingMeasureBase
extends MeasureBase {
    protected double sum;
    protected int count;

    @Override
    public void reset() {
        this.sum = 0.0;
        this.count = 0;
    }

    @Override
    public double getValue() {
        return this.sum / (double)this.count;
    }

    @Override
    protected void updateInternal(MultiLabelOutput prediction, boolean[] truth) {
        int[] ranking = prediction.getRanking();
        if (ranking == null) {
            throw new ArgumentNullException("Bipartition is null");
        }
        if (ranking.length != truth.length) {
            throw new IllegalArgumentException("The dimensions of the bipartition and the ground truth array do not match");
        }
        this.updateRanking(ranking, truth);
    }

    protected abstract void updateRanking(int[] var1, boolean[] var2);
}

