/*
 * Decompiled with CFR 0.152.
 */
package mulan.evaluation.measure;

import java.util.Collections;
import mulan.evaluation.measure.LabelBasedAveragePrecision;
import mulan.evaluation.measure.MacroAverageMeasure;

public class MeanAveragePrecision
extends LabelBasedAveragePrecision
implements MacroAverageMeasure {
    public MeanAveragePrecision(int numOfLabels) {
        super(numOfLabels);
    }

    @Override
    public double getValue() {
        int zeroRelevantCounter = 0;
        double map = 0.0;
        for (int labelIndex = 0; labelIndex < this.numOfLabels; ++labelIndex) {
            double ap = this.getValue(labelIndex);
            if (ap >= 0.0) {
                map += ap;
                continue;
            }
            ++zeroRelevantCounter;
        }
        return map / (double)(this.numOfLabels - zeroRelevantCounter);
    }

    @Override
    public double getValue(int labelIndex) {
        double ap = 0.0;
        Collections.sort(this.confact[labelIndex], Collections.reverseOrder());
        double retrievedCounter = 0.0;
        double relevantCounter = 0.0;
        for (int i = 0; i < this.confact[labelIndex].size(); ++i) {
            retrievedCounter += 1.0;
            Boolean actual = ((LabelBasedAveragePrecision.ConfidenceActual)this.confact[labelIndex].get(i)).getActual();
            if (!actual.booleanValue()) continue;
            ap += (relevantCounter += 1.0) / retrievedCounter;
        }
        return ap /= relevantCounter;
    }

    @Override
    public String getName() {
        return "Mean Average Precision";
    }

    @Override
    public double getIdealValue() {
        return 1.0;
    }
}

