/*
 * Decompiled with CFR 0.152.
 */
package mulan.evaluation.measure;

import mulan.evaluation.measure.InformationRetrievalMeasures;
import mulan.evaluation.measure.LabelBasedFMeasure;
import mulan.evaluation.measure.MacroAverageMeasure;

public class MacroFMeasure
extends LabelBasedFMeasure
implements MacroAverageMeasure {
    public MacroFMeasure(int numOfLabels) {
        this(numOfLabels, 1.0);
    }

    public MacroFMeasure(int numOfLabels, double beta) {
        super(numOfLabels, beta);
    }

    @Override
    public String getName() {
        return "Macro-averaged F-Measure";
    }

    @Override
    public double getValue() {
        double sum = 0.0;
        int count = 0;
        for (int labelIndex = 0; labelIndex < this.numOfLabels; ++labelIndex) {
            sum += InformationRetrievalMeasures.fMeasure(this.truePositives[labelIndex], this.falsePositives[labelIndex], this.falseNegatives[labelIndex], this.beta);
            ++count;
        }
        return sum / (double)count;
    }

    @Override
    public double getValue(int labelIndex) {
        return InformationRetrievalMeasures.fMeasure(this.truePositives[labelIndex], this.falsePositives[labelIndex], this.falseNegatives[labelIndex], this.beta);
    }
}

