/*
 * Decompiled with CFR 0.152.
 */
package mulan.evaluation.measure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import mulan.evaluation.measure.ConfidenceMeasureBase;

public abstract class LabelBasedAveragePrecision
extends ConfidenceMeasureBase {
    protected int numOfLabels;
    protected List<ConfidenceActual>[] confact;

    public LabelBasedAveragePrecision(int numOfLabels) {
        this.numOfLabels = numOfLabels;
        this.confact = new ArrayList[numOfLabels];
        for (int labelIndex = 0; labelIndex < numOfLabels; ++labelIndex) {
            this.confact[labelIndex] = new ArrayList<ConfidenceActual>();
        }
    }

    @Override
    protected void updateConfidence(double[] confidences, boolean[] truth) {
        for (int labelIndex = 0; labelIndex < this.numOfLabels; ++labelIndex) {
            boolean actual = truth[labelIndex];
            double confidence = confidences[labelIndex];
            this.confact[labelIndex].add(new ConfidenceActual(confidence, actual));
        }
    }

    @Override
    public void reset() {
        for (int labelIndex = 0; labelIndex < this.numOfLabels; ++labelIndex) {
            this.confact[labelIndex].clear();
        }
    }

    protected class ConfidenceActual
    implements Comparable,
    Serializable {
        private boolean actual;
        private double confidence;

        public ConfidenceActual(double confidence, boolean actual) {
            this.actual = actual;
            this.confidence = confidence;
        }

        public boolean getActual() {
            return this.actual;
        }

        public double getConfidence() {
            return this.confidence;
        }

        public int compareTo(Object o) {
            if (this.confidence > ((ConfidenceActual)o).confidence) {
                return 1;
            }
            if (this.confidence < ((ConfidenceActual)o).confidence) {
                return -1;
            }
            return 0;
        }
    }
}

