/*
 * Decompiled with CFR 0.152.
 */
package mulan.evaluation.measure;

import java.util.ArrayList;
import java.util.Iterator;
import mulan.evaluation.measure.RankingMeasureBase;

public class AveragePrecision
extends RankingMeasureBase {
    @Override
    public String getName() {
        return "Average Precision";
    }

    @Override
    public double getIdealValue() {
        return 1.0;
    }

    @Override
    protected void updateRanking(int[] ranking, boolean[] trueLabels) {
        double avgP = 0.0;
        int numLabels = trueLabels.length;
        ArrayList<Integer> relevant = new ArrayList<Integer>();
        for (int index = 0; index < numLabels; ++index) {
            if (!trueLabels[index]) continue;
            relevant.add(index);
        }
        if (relevant.size() != 0) {
            Iterator i$ = relevant.iterator();
            while (i$.hasNext()) {
                int r = (Integer)i$.next();
                double rankedAbove = 0.0;
                Iterator i$2 = relevant.iterator();
                while (i$2.hasNext()) {
                    int rr = (Integer)i$2.next();
                    if (ranking[rr] > ranking[r]) continue;
                    rankedAbove += 1.0;
                }
                avgP += rankedAbove / (double)ranking[r];
            }
            this.sum += (avgP /= (double)relevant.size());
            ++this.count;
        }
    }
}

