/*
 * Decompiled with CFR 0.152.
 */
package mulan.evaluation.loss;

import java.io.Serializable;
import mulan.classifier.MultiLabelOutput;
import mulan.core.ArgumentNullException;
import mulan.evaluation.loss.RankingLossFunction;

public abstract class RankingLossFunctionBase
implements RankingLossFunction,
Serializable {
    private void checkRanking(int[] ranking) {
        if (ranking == null) {
            throw new ArgumentNullException("Ranking is null");
        }
    }

    private void checkLength(int[] ranking, boolean[] groundTruth) {
        if (ranking.length != groundTruth.length) {
            throw new IllegalArgumentException("The dimensions of the ranking and the ground truth array do not match");
        }
    }

    @Override
    public final double computeLoss(MultiLabelOutput prediction, boolean[] groundTruth) {
        int[] ranking = prediction.getRanking();
        this.checkRanking(ranking);
        this.checkLength(ranking, groundTruth);
        return this.computeLoss(ranking, groundTruth);
    }

    @Override
    public abstract double computeLoss(int[] var1, boolean[] var2);
}

