/*
 * Decompiled with CFR 0.152.
 */
package mulan.evaluation;

import java.util.ArrayList;
import java.util.List;
import mulan.data.MultiLabelInstances;
import mulan.evaluation.measure.MacroAverageMeasure;
import mulan.evaluation.measure.Measure;

public class Evaluation {
    private MultiLabelInstances data;
    private List<Measure> measures = new ArrayList<Measure>();

    public Evaluation(List<Measure> someMeasures, MultiLabelInstances data) throws Exception {
        for (Measure m : someMeasures) {
            Measure newMeasure = m.makeCopy();
            this.measures.add(newMeasure);
        }
        this.data = data;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Measure m : this.measures) {
            sb.append(m);
            if (m instanceof MacroAverageMeasure) {
                sb.append("\n");
                for (int i = 0; i < this.data.getNumLabels(); ++i) {
                    sb.append(this.data.getDataSet().attribute(this.data.getLabelIndices()[i]).name()).append(": ").append(((MacroAverageMeasure)((Object)m)).getValue(i)).append(" ");
                }
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toCSV() {
        StringBuilder sb = new StringBuilder();
        for (Measure m : this.measures) {
            double value = Double.NaN;
            try {
                value = m.getValue();
            }
            catch (Exception ex) {
                // empty catch block
            }
            sb.append(String.format("%.4f", value));
            sb.append(";");
        }
        return sb.toString();
    }

    public List<Measure> getMeasures() {
        return this.measures;
    }
}

