/*
 * Decompiled with CFR 0.152.
 */
package mulan.data;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import mulan.classifier.MultiLabelLearner;
import mulan.classifier.meta.SubsetLearner;
import mulan.data.LabelClustering;
import mulan.data.LabelPairsDependenceIdentifier;
import mulan.data.LabelsPair;
import mulan.data.MultiLabelInstances;
import mulan.evaluation.Evaluator;
import mulan.evaluation.MultipleEvaluation;
import mulan.evaluation.measure.Measure;
import mulan.evaluation.measure.SubsetAccuracy;
import weka.classifiers.Classifier;

public class GreedyLabelClustering
implements LabelClustering,
Serializable {
    private Classifier singleLabelLearner;
    private MultiLabelLearner multiLabelLearner;
    private LabelPairsDependenceIdentifier depLabelsIdentifier;
    private double criticalValue = 0.0;
    private int numFolds = 10;
    private int allowedNonImprovementSteps = 10;
    private Measure measure = new SubsetAccuracy();
    private boolean useSubsetLearnerCache = true;
    private boolean internalSubsetLearnerDebug = true;

    public GreedyLabelClustering(MultiLabelLearner aMultiLabelLearner, Classifier aSingleLabelLearner, LabelPairsDependenceIdentifier dependenceIdentifier) {
        this.multiLabelLearner = aMultiLabelLearner;
        this.depLabelsIdentifier = dependenceIdentifier;
        this.singleLabelLearner = aSingleLabelLearner;
    }

    @Override
    public int[][] determineClusters(MultiLabelInstances trainingSet) {
        HashMap<String, int[][]> evaluatedSubsets = new HashMap<String, int[][]>();
        Evaluator eval = new Evaluator();
        if (this.criticalValue == 0.0) {
            this.criticalValue = this.depLabelsIdentifier.getCriticalValue();
        }
        LabelsPair[] labelPairs = this.depLabelsIdentifier.calculateDependence(trainingSet);
        int numLabels = trainingSet.getNumLabels();
        int[][] currClusters = GreedyLabelClustering.buildInitialSet(numLabels);
        String currSubsetsStr = GreedyLabelClustering.partitionToString(currClusters);
        System.out.println("Evaluating initial model: " + currSubsetsStr);
        SubsetLearner currClassif = new SubsetLearner(currClusters, this.multiLabelLearner, this.singleLabelLearner);
        currClassif.setDebug(this.internalSubsetLearnerDebug);
        currClassif.setUseCache(this.useSubsetLearnerCache);
        MultipleEvaluation results = eval.crossValidate(currClassif, trainingSet, this.numFolds);
        results.calculateStatistics();
        Double currAcc = results.getMean(this.measure.getName());
        System.out.println("Model's " + this.measure.getName() + " = " + currAcc);
        evaluatedSubsets.put(currSubsetsStr, currClusters);
        int noImprovementCounter = 0;
        for (LabelsPair pair : labelPairs) {
            int[][] newClusters;
            Double score = pair.getScore();
            if (score < this.criticalValue) {
                System.out.println("Pairs dependence score: " + score + " is below the criticalValue: " + this.criticalValue + ". Stop the clustering process!");
                break;
            }
            if (noImprovementCounter > this.allowedNonImprovementSteps) {
                System.out.println("noImprovementCounter: " + noImprovementCounter + " is above the allowed: " + this.allowedNonImprovementSteps + ". Stop the clustering process!");
                break;
            }
            int[] comb = pair.getPair();
            int length = currClusters.length;
            if (length == 1) {
                System.out.println("All labels are in the same group. Stop the clustering process!");
                break;
            }
            for (int[] newCluster : newClusters = GreedyLabelClustering.buildCombinationSet(currClusters, comb)) {
                Arrays.sort(newCluster);
            }
            String newSubsetsStr = GreedyLabelClustering.partitionToString(newClusters);
            if (evaluatedSubsets.containsKey(newSubsetsStr)) continue;
            System.out.println("Evaluating model:" + newSubsetsStr);
            currClassif.resetSubsets(newClusters);
            results = eval.crossValidate(currClassif, trainingSet, this.numFolds);
            evaluatedSubsets.put(newSubsetsStr, newClusters);
            results.calculateStatistics();
            Double newAcc = results.getMean(this.measure.getName());
            System.out.println("Model's " + this.measure.getName() + " = " + newAcc);
            if (newAcc >= currAcc) {
                currClusters = newClusters;
                currAcc = newAcc;
                noImprovementCounter = 0;
                continue;
            }
            ++noImprovementCounter;
        }
        System.out.println("Returning  the final labels partition: " + GreedyLabelClustering.partitionToString(currClusters) + '\n');
        return currClusters;
    }

    public static String partitionToString(int[][] partition) {
        StringBuilder result = new StringBuilder();
        for (int[] aGroup : partition) {
            result.append(Arrays.toString(aGroup));
            result.append(", ");
        }
        return result.toString();
    }

    private static int[][] buildInitialSet(int numLabels) {
        int[][] res = new int[numLabels][1];
        for (int i = 0; i < numLabels; ++i) {
            res[i][0] = i;
        }
        return res;
    }

    private static int[][] buildCombinationSet(int[][] partition, int[] pair) {
        int[][] newClusters = new int[partition.length - 1][];
        int[][] tmpClusters = new int[partition.length][];
        int i1 = -1;
        int i2 = -1;
        for (int i = 0; i < partition.length; ++i) {
            for (int j = 0; j < partition[i].length; ++j) {
                if (partition[i][j] == pair[0]) {
                    i1 = i;
                }
                if (partition[i][j] != pair[1]) continue;
                i2 = i;
            }
        }
        if (i1 == i2) {
            return partition;
        }
        for (int k = 0; k < partition.length; ++k) {
            if (i1 > i2) {
                int temp = i1;
                i1 = i2;
                i2 = temp;
            }
            if (k != i1) {
                tmpClusters[k] = partition[k];
                continue;
            }
            tmpClusters[k] = new int[partition[i1].length + partition[i2].length];
            for (int m = 0; m < partition[i1].length; ++m) {
                tmpClusters[k][m] = partition[i1][m];
            }
            for (int n = 0; n < partition[i2].length; ++n) {
                tmpClusters[k][m + n] = partition[i2][n];
            }
        }
        System.arraycopy(tmpClusters, 0, newClusters, 0, i2);
        System.arraycopy(tmpClusters, i2 + 1, newClusters, i2, newClusters.length - i2);
        return newClusters;
    }

    public int getNumFolds() {
        return this.numFolds;
    }

    public void setNumFolds(int numFolds) {
        this.numFolds = numFolds;
    }

    public Measure getMeasure() {
        return this.measure;
    }

    public void setMeasure(Measure measure) {
        this.measure = measure;
    }

    public int getAllowedNonImprovementSteps() {
        return this.allowedNonImprovementSteps;
    }

    public void setAllowedNonImprovementSteps(int allowedNonImprovementSteps) {
        this.allowedNonImprovementSteps = allowedNonImprovementSteps;
    }

    public double getCriticalValue() {
        return this.criticalValue;
    }

    public void setCriticalValue(double criticalValue) {
        this.criticalValue = criticalValue;
    }

    public Classifier getSingleLabelLearner() {
        return this.singleLabelLearner;
    }

    public MultiLabelLearner getMultiLabelLearner() {
        return this.multiLabelLearner;
    }

    public boolean isUseSubsetLearnerCache() {
        return this.useSubsetLearnerCache;
    }

    public void setUseSubsetLearnerCache(boolean useSubsetLearnerCache) {
        this.useSubsetLearnerCache = useSubsetLearnerCache;
    }

    public boolean isInternalSubsetLearnerDebug() {
        return this.internalSubsetLearnerDebug;
    }

    public void setInternalSubsetLearnerDebug(boolean internalSubsetLearnerDebug) {
        this.internalSubsetLearnerDebug = internalSubsetLearnerDebug;
    }
}

