/*
 * Decompiled with CFR 0.152.
 */
package mulan.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import weka.core.AllJavadoc;
import weka.core.Utils;

public class MulanJavadoc {
    static File originalDir;
    static String dir;

    public static void setDir(String dir) {
        MulanJavadoc.dir = dir;
    }

    public static void main(String[] args) throws Exception {
        dir = Utils.getOption((String)"dir", (String[])args);
        originalDir = new File(dir);
        MulanJavadoc.traverse();
    }

    public static void updateJavadoc(String classname) {
        try {
            AllJavadoc jdoc = new AllJavadoc();
            jdoc.setClassname(classname);
            jdoc.setDir(dir);
            jdoc.setUseStars(false);
            String result = jdoc.updateJavadoc();
            if (!result.isEmpty()) {
                File file = new File(jdoc.getDir() + "/" + jdoc.getClassname().replaceAll("\\.", "/") + ".java");
                if (!file.exists()) {
                    System.out.println("File '" + file.getAbsolutePath() + "' doesn't exist!");
                    return;
                }
                BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                writer.write(result);
                writer.close();
                System.out.println(jdoc.getClassname() + "'s Javadoc successfully updated.");
            } else {
                System.out.println(jdoc.getClassname() + "'s Javadoc update failed. Skipping file..");
            }
        }
        catch (Exception ex) {
            Logger.getLogger(MulanJavadoc.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void traverse() throws Exception {
        MulanJavadoc.recursiveTraversal(originalDir);
    }

    public static void recursiveTraversal(File fileObject) throws Exception {
        String classname;
        if (fileObject.isDirectory()) {
            File[] allFiles;
            for (File aFile : allFiles = fileObject.listFiles()) {
                MulanJavadoc.recursiveTraversal(aFile);
            }
        } else if (fileObject.isFile() && (classname = fileObject.getPath()).endsWith(".java")) {
            classname = classname.replace(".java", "");
            classname = classname.replace(dir, "");
            classname = classname.replaceAll("\\\\", "\\.");
            System.out.println(classname);
            MulanJavadoc.updateJavadoc(classname);
        }
    }

    public String globalInfo() {
        return "This class uses weka's Javadoc auto-generation classes to generate Javadoc\ncomments and replaces the content between certain comment tags.";
    }
}

