/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier.transformation;

import mulan.classifier.MultiLabelOutput;
import mulan.classifier.transformation.TransformationBasedMultiLabelLearner;
import mulan.data.MultiLabelInstances;
import mulan.transformations.RemoveAllLabels;
import mulan.transformations.multiclass.MultiClassTransformation;
import weka.classifiers.Classifier;
import weka.core.Instance;
import weka.core.Instances;

public class MultiClassLearner
extends TransformationBasedMultiLabelLearner {
    private Instances header;
    private MultiClassTransformation transformation;

    public MultiClassLearner(Classifier baseClassifier, MultiClassTransformation dt) {
        super(baseClassifier);
        this.transformation = dt;
    }

    @Override
    protected void buildInternal(MultiLabelInstances train) throws Exception {
        this.debug("Transforming the training set");
        Instances meta = this.transformation.transformInstances(train);
        this.baseClassifier.buildClassifier(meta);
        this.header = new Instances(meta, 0);
    }

    @Override
    protected MultiLabelOutput makePredictionInternal(Instance instance) throws Exception {
        instance = RemoveAllLabels.transformInstance(instance, this.labelIndices);
        instance.setDataset(null);
        instance.insertAttributeAt(instance.numAttributes());
        instance.setDataset(this.header);
        double[] distribution = this.baseClassifier.distributionForInstance(instance);
        MultiLabelOutput mlo = new MultiLabelOutput(MultiLabelOutput.ranksFromValues(distribution));
        return mlo;
    }
}

