/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier.transformation;

import java.util.Arrays;
import java.util.Random;
import mulan.classifier.InvalidDataException;
import mulan.classifier.MultiLabelOutput;
import mulan.classifier.transformation.ClassifierChain;
import mulan.classifier.transformation.TransformationBasedMultiLabelLearner;
import mulan.data.MultiLabelInstances;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.TechnicalInformation;
import weka.filters.Filter;
import weka.filters.unsupervised.instance.RemovePercentage;

public class EnsembleOfClassifierChains
extends TransformationBasedMultiLabelLearner {
    protected int numOfModels;
    protected ClassifierChain[] ensemble;
    protected Random rand;
    protected boolean useConfidences;
    protected boolean useSamplingWithReplacement = true;
    protected int BagSizePercent = 100;
    protected double samplingPercentage = 67.0;

    public int getBagSizePercent() {
        return this.BagSizePercent;
    }

    public void setBagSizePercent(int bagSizePercent) {
        this.BagSizePercent = bagSizePercent;
    }

    public double getSamplingPercentage() {
        return this.samplingPercentage;
    }

    public void setSamplingPercentage(double samplingPercentage) {
        this.samplingPercentage = samplingPercentage;
    }

    public EnsembleOfClassifierChains() {
        this((Classifier)new J48(), 10, true, true);
    }

    public EnsembleOfClassifierChains(Classifier classifier, int aNumOfModels, boolean doUseConfidences, boolean doUseSamplingWithReplacement) {
        super(classifier);
        this.numOfModels = aNumOfModels;
        this.useConfidences = doUseConfidences;
        this.useSamplingWithReplacement = doUseSamplingWithReplacement;
        this.ensemble = new ClassifierChain[aNumOfModels];
        this.rand = new Random(1L);
    }

    @Override
    public String globalInfo() {
        return "Class implementing the Ensemble of Classifier Chains(ECC) algorithm. For more information, see\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Read, Jesse and Pfahringer, Bernhard and Holmes, Geoff and Frank, Eibe");
        result.setValue(TechnicalInformation.Field.TITLE, "Classifier Chains for Multi-label Classification");
        result.setValue(TechnicalInformation.Field.VOLUME, "85");
        result.setValue(TechnicalInformation.Field.NUMBER, "3");
        result.setValue(TechnicalInformation.Field.YEAR, "2011");
        result.setValue(TechnicalInformation.Field.PAGES, "335--359");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning");
        return result;
    }

    @Override
    protected void buildInternal(MultiLabelInstances trainingSet) throws Exception {
        Instances dataSet = new Instances(trainingSet.getDataSet());
        for (int i = 0; i < this.numOfModels; ++i) {
            int j;
            Instances sampledDataSet;
            this.debug("ECC Building Model:" + (i + 1) + "/" + this.numOfModels);
            dataSet.randomize(this.rand);
            if (this.useSamplingWithReplacement) {
                int bagSize = dataSet.numInstances() * this.BagSizePercent / 100;
                sampledDataSet = dataSet.resampleWithWeights(new Random(1L));
                if (bagSize < dataSet.numInstances()) {
                    sampledDataSet = new Instances(sampledDataSet, 0, bagSize);
                }
            } else {
                RemovePercentage rmvp = new RemovePercentage();
                rmvp.setInvertSelection(true);
                rmvp.setPercentage(this.samplingPercentage);
                rmvp.setInputFormat(dataSet);
                sampledDataSet = Filter.useFilter((Instances)dataSet, (Filter)rmvp);
            }
            MultiLabelInstances train = new MultiLabelInstances(sampledDataSet, trainingSet.getLabelsMetaData());
            int[] chain = new int[this.numLabels];
            for (j = 0; j < this.numLabels; ++j) {
                chain[j] = j;
            }
            for (j = 0; j < chain.length; ++j) {
                int randomPosition = this.rand.nextInt(chain.length);
                int temp = chain[j];
                chain[j] = chain[randomPosition];
                chain[randomPosition] = temp;
            }
            this.debug(Arrays.toString(chain));
            this.ensemble[i] = new ClassifierChain(this.baseClassifier, chain);
            this.ensemble[i].build(train);
        }
    }

    @Override
    protected MultiLabelOutput makePredictionInternal(Instance instance) throws Exception, InvalidDataException {
        int[] sumVotes = new int[this.numLabels];
        double[] sumConf = new double[this.numLabels];
        Arrays.fill(sumVotes, 0);
        Arrays.fill(sumConf, 0.0);
        for (int i = 0; i < this.numOfModels; ++i) {
            MultiLabelOutput ensembleMLO = this.ensemble[i].makePrediction(instance);
            boolean[] bip = ensembleMLO.getBipartition();
            double[] conf = ensembleMLO.getConfidences();
            for (int j = 0; j < this.numLabels; ++j) {
                int n = j;
                sumVotes[n] = sumVotes[n] + (bip[j] ? 1 : 0);
                int n2 = j;
                sumConf[n2] = sumConf[n2] + conf[j];
            }
        }
        double[] confidence = new double[this.numLabels];
        for (int j = 0; j < this.numLabels; ++j) {
            confidence[j] = this.useConfidences ? sumConf[j] / (double)this.numOfModels : (double)sumVotes[j] / (double)this.numOfModels;
        }
        MultiLabelOutput mlo = new MultiLabelOutput(confidence, 0.5);
        return mlo;
    }
}

