/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier.transformation;

import mulan.classifier.MultiLabelOutput;
import mulan.classifier.transformation.TransformationBasedMultiLabelLearner;
import mulan.data.MultiLabelInstances;
import mulan.transformations.BinaryRelevanceTransformation;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.Instance;
import weka.core.Instances;

public class BinaryRelevance
extends TransformationBasedMultiLabelLearner {
    protected Classifier[] ensemble;
    private String[] correspondence;
    private BinaryRelevanceTransformation brt;

    public BinaryRelevance(Classifier classifier) {
        super(classifier);
    }

    @Override
    protected void buildInternal(MultiLabelInstances train) throws Exception {
        int i;
        this.ensemble = new Classifier[this.numLabels];
        this.correspondence = new String[this.numLabels];
        for (i = 0; i < this.numLabels; ++i) {
            this.correspondence[i] = train.getDataSet().attribute(this.labelIndices[i]).name();
        }
        this.debug("preparing shell");
        this.brt = new BinaryRelevanceTransformation(train);
        for (i = 0; i < this.numLabels; ++i) {
            this.ensemble[i] = AbstractClassifier.makeCopy((Classifier)this.baseClassifier);
            Instances shell = this.brt.transformInstances(i);
            this.debug("Bulding model " + (i + 1) + "/" + this.numLabels);
            this.ensemble[i].buildClassifier(shell);
        }
    }

    @Override
    protected MultiLabelOutput makePredictionInternal(Instance instance) {
        boolean[] bipartition = new boolean[this.numLabels];
        double[] confidences = new double[this.numLabels];
        for (int counter = 0; counter < this.numLabels; ++counter) {
            double[] distribution;
            Instance transformedInstance = this.brt.transformInstance(instance, counter);
            try {
                distribution = this.ensemble[counter].distributionForInstance(transformedInstance);
            }
            catch (Exception e) {
                System.out.println(e);
                return null;
            }
            boolean maxIndex = !(distribution[0] > distribution[1]);
            bipartition[counter] = maxIndex;
            confidences[counter] = distribution[1];
        }
        MultiLabelOutput mlo = new MultiLabelOutput(bipartition, confidences);
        return mlo;
    }

    public Classifier getModel(String labelName) {
        for (int i = 0; i < this.numLabels; ++i) {
            if (!this.correspondence[i].equals(labelName)) continue;
            return this.ensemble[i];
        }
        return null;
    }
}

