/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier.neural.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import mulan.classifier.neural.model.ActivationFunction;
import mulan.core.ArgumentNullException;

public class Neuron
implements Serializable {
    private static final long serialVersionUID = -2826468439369586864L;
    private double[] inputWeights;
    private double[] deltaValues;
    private double errorValue;
    private final ActivationFunction function;
    private final double biasInput;
    private double neuronInput;
    private double neuronOutput;
    private List<Neuron> nextNeurons;
    private final int inputDim;
    private final Random random;

    public Neuron(ActivationFunction function, int inputDim, double biasValue) {
        this(function, inputDim, biasValue, new Random());
    }

    public Neuron(ActivationFunction function, int inputDim, double biasValue, Random random) {
        if (function == null) {
            throw new ArgumentNullException("function");
        }
        if (inputDim <= 0) {
            throw new IllegalArgumentException("Input dimension for the neuron must be greather than zero.");
        }
        this.inputDim = inputDim;
        this.function = function;
        this.biasInput = biasValue;
        this.inputWeights = new double[inputDim + 1];
        this.deltaValues = new double[inputDim + 1];
        this.nextNeurons = new ArrayList<Neuron>();
        this.random = random == null ? new Random() : random;
        this.reset();
    }

    public Neuron(ActivationFunction function, int inputDim, double biasValue, Collection<Neuron> nextNeurons) {
        this(function, inputDim, biasValue);
        if (nextNeurons == null) {
            throw new IllegalArgumentException("Collection of connexted neurons is null.");
        }
        this.nextNeurons = new ArrayList<Neuron>(nextNeurons);
    }

    public ActivationFunction getActivationFunction() {
        return this.function;
    }

    public double[] getWeights() {
        return this.inputWeights;
    }

    public double getError() {
        return this.errorValue;
    }

    public void setError(double error) {
        this.errorValue = error;
    }

    public double[] getDeltas() {
        return this.deltaValues;
    }

    public double processInput(double[] inputs) {
        if (inputs == null) {
            throw new IllegalArgumentException("The input pattern for processing is null.");
        }
        if (inputs.length != this.inputDim) {
            throw new IllegalArgumentException("The dimension of input pattern vector does not match dimenstion of the neuron.");
        }
        this.neuronInput = 0.0;
        for (int i = 0; i < this.inputDim; ++i) {
            this.neuronInput += this.inputWeights[i] * inputs[i];
        }
        this.neuronInput += this.inputWeights[this.inputDim] * this.biasInput;
        this.neuronOutput = this.function.activate(this.neuronInput);
        return this.neuronOutput;
    }

    public double getOutput() {
        return this.neuronOutput;
    }

    public double getNeuronInput() {
        return this.neuronInput;
    }

    public double getBiasInput() {
        return this.biasInput;
    }

    public boolean addNeuron(Neuron neuron) {
        if (neuron == null) {
            throw new IllegalArgumentException("Neuron should not be null.");
        }
        if (this.nextNeurons.contains(neuron)) {
            return false;
        }
        return this.nextNeurons.add(neuron);
    }

    public boolean addAllNeurons(Collection<Neuron> neurons) {
        if (neurons == null) {
            throw new IllegalArgumentException("Neurons collection should not be null.");
        }
        Neuron[] items = neurons.toArray(new Neuron[0]);
        boolean nothingAdded = true;
        for (Neuron item : items) {
            nothingAdded &= !this.addNeuron(item);
        }
        return !nothingAdded;
    }

    public boolean removeNeuron(Neuron neuron) {
        if (neuron == null) {
            throw new IllegalArgumentException("Neuron should not be null.");
        }
        return this.nextNeurons.remove(neuron);
    }

    public void reset() {
        double max = 0.5;
        double min = -0.5;
        int inputsCount = this.inputDim + 1;
        this.errorValue = 0.0;
        this.neuronInput = 0.0;
        this.neuronOutput = 0.0;
        Arrays.fill(this.deltaValues, 0.0);
        for (int i = 0; i < inputsCount; ++i) {
            this.inputWeights[i] = this.random.nextDouble() * 1.0 + -0.5;
        }
    }

    protected int getConnectedNeuronsCount() {
        return this.nextNeurons.size();
    }
}

