/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier.neural;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Set;
import mulan.data.MultiLabelInstances;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.experiment.Stats;

public class NormalizationFilter
implements Serializable {
    private static final long serialVersionUID = -2575012048861337275L;
    private final double maxValue;
    private final double minValue;
    private Hashtable<Integer, double[]> attStats;

    public NormalizationFilter(MultiLabelInstances mlData, boolean performNormalization, double minValue, double maxValue) {
        if (mlData == null) {
            throw new IllegalArgumentException("Parameter 'mlData' is null.");
        }
        if (maxValue <= minValue) {
            throw new IllegalArgumentException(String.format("Parameters 'minValue=%f' and 'maxValue=%f' does not define valid range.", minValue, maxValue));
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.attStats = new Hashtable();
        this.Initialize(mlData);
        if (performNormalization) {
            Instances instances = mlData.getDataSet();
            int numInstance = instances.numInstances();
            for (int i = 0; i < numInstance; ++i) {
                this.normalize(instances.instance(i));
            }
        }
    }

    public NormalizationFilter(MultiLabelInstances mlData, boolean performNormalization) {
        this(mlData, performNormalization, -1.0, 1.0);
    }

    public void normalize(Instance instance) {
        Set<Integer> normScope = this.attStats.keySet();
        for (Integer attIndex : normScope) {
            double[] stats = this.attStats.get(attIndex);
            double attMin = stats[0];
            double attMax = stats[1];
            double value = instance.value(attIndex.intValue());
            if (attMin == attMax) {
                instance.setValue(attIndex.intValue(), this.minValue);
                continue;
            }
            instance.setValue(attIndex.intValue(), (value - stats[0]) / (stats[1] - stats[0]) * (this.maxValue - this.minValue) + this.minValue);
        }
    }

    private void Initialize(MultiLabelInstances mlData) {
        int[] featureIndices;
        Instances dataSet = mlData.getDataSet();
        for (int attIndex : featureIndices = mlData.getFeatureIndices()) {
            Attribute feature = dataSet.attribute(attIndex);
            if (!feature.isNumeric()) continue;
            Stats stats = dataSet.attributeStats((int)attIndex).numericStats;
            this.attStats.put(attIndex, new double[]{stats.min, stats.max});
        }
    }
}

