/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier.neural;

import java.util.List;
import mulan.classifier.neural.DataPair;
import mulan.classifier.neural.MMPUpdateRuleBase;
import mulan.classifier.neural.model.Neuron;
import mulan.evaluation.loss.RankingLossFunction;

public class MMPMaxUpdateRule
extends MMPUpdateRuleBase {
    public MMPMaxUpdateRule(List<Neuron> perceptrons, RankingLossFunction lossMeasure) {
        super(perceptrons, lossMeasure);
    }

    @Override
    protected double[] computeUpdateParameters(DataPair example, double[] confidences, double loss) {
        int numLabels = example.getOutput().length;
        boolean[] trueOutput = example.getOutputBoolean();
        int lrLabel = -1;
        int hirLabel = -1;
        for (int index = 0; index < numLabels; ++index) {
            if (trueOutput[index]) {
                if (lrLabel == -1) {
                    lrLabel = index;
                }
                if (!(confidences[index] <= confidences[lrLabel])) continue;
                lrLabel = index;
                continue;
            }
            if (hirLabel == -1) {
                hirLabel = index;
            }
            if (!(confidences[index] >= confidences[hirLabel])) continue;
            hirLabel = index;
        }
        double[] params = new double[numLabels];
        params[lrLabel] = loss;
        params[hirLabel] = -loss;
        return params;
    }
}

