/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier.meta.thresholding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import mulan.classifier.MultiLabelLearner;
import mulan.classifier.MultiLabelOutput;
import mulan.classifier.meta.thresholding.Meta;
import mulan.classifier.transformation.BinaryRelevance;
import mulan.data.DataUtils;
import mulan.data.MultiLabelInstances;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.TechnicalInformation;

public class ThresholdPrediction
extends Meta {
    public ThresholdPrediction() {
        this(new BinaryRelevance((Classifier)new J48()), (Classifier)new J48(), "Content-Based", 3);
    }

    public ThresholdPrediction(MultiLabelLearner baseLearner, Classifier classifier, String metaDataChoice, int folds) {
        super(baseLearner, classifier, metaDataChoice);
        try {
            this.foldLearner = baseLearner.makeCopy();
        }
        catch (Exception ex) {
            Logger.getLogger(ThresholdPrediction.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.kFoldsCV = folds;
    }

    @Override
    protected MultiLabelOutput makePredictionInternal(Instance instance) throws Exception {
        boolean[] predictedLabels = new boolean[this.numLabels];
        Instance modifiedIns = this.modifiedInstanceX(instance, this.metaDatasetChoice);
        modifiedIns.insertAttributeAt(modifiedIns.numAttributes());
        modifiedIns.setDataset(this.classifierInstances);
        double bipartition_key = this.classifier.classifyInstance(modifiedIns);
        MultiLabelOutput mlo = this.baseLearner.makePrediction(instance);
        double[] arrayOfScores = new double[this.numLabels];
        arrayOfScores = mlo.getConfidences();
        for (int i = 0; i < this.numLabels; ++i) {
            predictedLabels[i] = arrayOfScores[i] >= bipartition_key;
        }
        MultiLabelOutput final_mlo = new MultiLabelOutput(predictedLabels, mlo.getConfidences());
        return final_mlo;
    }

    @Override
    public Instances transformData(MultiLabelInstances trainingData) throws Exception {
        this.classifierInstances = this.prepareClassifierInstances(trainingData);
        this.classifierInstances.insertAttributeAt(new Attribute("Threshold"), this.classifierInstances.numAttributes());
        this.classifierInstances.setClassIndex(this.classifierInstances.numAttributes() - 1);
        for (int k = 0; k < this.kFoldsCV; ++k) {
            MultiLabelInstances mlTest;
            MultiLabelLearner tempLearner;
            if (this.kFoldsCV == 1) {
                tempLearner = this.baseLearner;
                tempLearner.build(trainingData);
                mlTest = trainingData;
            } else {
                Instances train = trainingData.getDataSet().trainCV(this.kFoldsCV, k);
                Instances test = trainingData.getDataSet().testCV(this.kFoldsCV, k);
                MultiLabelInstances mlTrain = new MultiLabelInstances(train, trainingData.getLabelsMetaData());
                mlTest = new MultiLabelInstances(test, trainingData.getLabelsMetaData());
                tempLearner = this.foldLearner.makeCopy();
                tempLearner.build(mlTrain);
            }
            for (int instanceIndex = 0; instanceIndex < mlTest.getDataSet().numInstances(); ++instanceIndex) {
                Instance instance = mlTest.getDataSet().instance(instanceIndex);
                double[] newValues = new double[this.classifierInstances.numAttributes()];
                this.valuesX(tempLearner, instance, newValues, this.metaDatasetChoice);
                boolean[] trueLabels = new boolean[this.numLabels];
                for (int i = 0; i < this.numLabels; ++i) {
                    int labelIndice = this.labelIndices[i];
                    String classValue = mlTest.getDataSet().attribute(labelIndice).value((int)mlTest.getDataSet().instance(instanceIndex).value(labelIndice));
                    trueLabels[i] = classValue.equals("1");
                }
                MultiLabelOutput mlo = tempLearner.makePrediction(mlTest.getDataSet().instance(instanceIndex));
                double[] arrayOfScores = mlo.getConfidences();
                ArrayList<Double> list = new ArrayList<Double>();
                for (int i = 0; i < this.numLabels; ++i) {
                    list.add(arrayOfScores[i]);
                }
                Collections.sort(list);
                double tempThresshold = 0.0;
                double threshold = 0.0;
                double prev = (Double)list.get(0);
                int t = this.numLabels;
                int tempT = 0;
                for (Double x : list) {
                    tempThresshold = (x + prev) / 2.0;
                    for (int i = 0; i < this.numLabels; ++i) {
                        if (trueLabels[i] && arrayOfScores[i] <= tempThresshold) {
                            ++tempT;
                            continue;
                        }
                        if (trueLabels[i] || !(arrayOfScores[i] >= tempThresshold)) continue;
                        ++tempT;
                    }
                    if (tempT < t) {
                        t = tempT;
                        threshold = tempThresshold;
                    }
                    tempT = 0;
                    prev = x;
                }
                newValues[newValues.length - 1] = threshold;
                Instance newInstance = DataUtils.createInstance(mlTest.getDataSet().instance(instanceIndex), mlTest.getDataSet().instance(instanceIndex).weight(), newValues);
                this.classifierInstances.add(newInstance);
            }
        }
        return this.classifierInstances;
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Elisseeff, Andre and Weston, Jason");
        result.setValue(TechnicalInformation.Field.TITLE, "A kernel method for multi-labelled classification");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Proceedings of NIPS 14");
        result.setValue(TechnicalInformation.Field.YEAR, "2002");
        return result;
    }

    @Override
    public String globalInfo() {
        return "Class that learns to predict a different threshold per exampleFor more information, see\n\n" + this.getTechnicalInformation().toString();
    }
}

