/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier.meta;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.rules.DecisionTableHashKey;
import weka.clusterers.NumberOfClustersRequestable;
import weka.clusterers.RandomizableClusterer;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class ConstrainedKMeans
extends RandomizableClusterer
implements NumberOfClustersRequestable,
WeightedInstancesHandler {
    static final long serialVersionUID = -3235809600124455376L;
    private ArrayList[] bucket;
    private int bucketSize;
    private int maxIterations;
    private ReplaceMissingValues m_ReplaceMissingFilter;
    private int m_NumClusters = 2;
    private Instances m_ClusterCentroids;
    private Instances m_ClusterStdDevs;
    private int[][][] m_ClusterNominalCounts;
    private int[] m_ClusterSizes;
    private double[] m_Min;
    private double[] m_Max;
    private int m_Iterations = 0;
    private double[] m_squaredErrors;

    public ConstrainedKMeans() {
        this.m_SeedDefault = 10;
        this.setSeed(this.m_SeedDefault);
    }

    public String globalInfo() {
        return "Cluster data using the constrained k means algorithm";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        return result;
    }

    public void setMaxIterations(int x) {
        this.maxIterations = x;
    }

    public void buildClusterer(Instances data) throws Exception {
        int j;
        int i;
        int j2;
        for (int i2 = 0; i2 < this.m_NumClusters; ++i2) {
            this.bucket[i2] = new ArrayList();
        }
        this.bucketSize = (int)Math.ceil((double)data.numInstances() / (double)this.m_NumClusters);
        this.getCapabilities().testWithFail(data);
        this.m_Iterations = 0;
        this.m_ReplaceMissingFilter = new ReplaceMissingValues();
        Instances instances = new Instances(data);
        instances.setClassIndex(-1);
        this.m_ReplaceMissingFilter.setInputFormat(instances);
        instances = Filter.useFilter((Instances)instances, (Filter)this.m_ReplaceMissingFilter);
        this.m_Min = new double[instances.numAttributes()];
        this.m_Max = new double[instances.numAttributes()];
        for (int i3 = 0; i3 < instances.numAttributes(); ++i3) {
            this.m_Max[i3] = Double.NaN;
            this.m_Min[i3] = Double.NaN;
        }
        this.m_ClusterCentroids = new Instances(instances, this.m_NumClusters);
        int[] clusterAssignments = new int[instances.numInstances()];
        for (int i4 = 0; i4 < instances.numInstances(); ++i4) {
            this.updateMinMax(instances.instance(i4));
        }
        Random RandomO = new Random(this.getSeed());
        HashMap initC = new HashMap();
        DecisionTableHashKey hk = null;
        for (int j3 = instances.numInstances() - 1; j3 >= 0; --j3) {
            int instIndex = RandomO.nextInt(j3 + 1);
            hk = new DecisionTableHashKey(instances.instance(instIndex), instances.numAttributes(), true);
            if (!initC.containsKey(hk)) {
                this.m_ClusterCentroids.add(instances.instance(instIndex));
                initC.put(hk, null);
            }
            instances.swap(j3, instIndex);
            if (this.m_ClusterCentroids.numInstances() == this.m_NumClusters) break;
        }
        this.m_NumClusters = this.m_ClusterCentroids.numInstances();
        boolean converged = false;
        Instances[] tempI = new Instances[this.m_NumClusters];
        this.m_squaredErrors = new double[this.m_NumClusters];
        this.m_ClusterNominalCounts = new int[this.m_NumClusters][instances.numAttributes()][0];
        while (!converged) {
            for (j2 = 0; j2 < this.m_NumClusters; ++j2) {
                this.bucket[j2] = new ArrayList();
            }
            int emptyClusterCount = 0;
            ++this.m_Iterations;
            converged = true;
            for (i = 0; i < instances.numInstances(); ++i) {
                Instance toCluster = instances.instance(i);
                int newC = this.clusterProcessedInstance(toCluster, true);
                if (newC != clusterAssignments[i]) {
                    converged = false;
                }
                clusterAssignments[i] = newC;
            }
            if (this.m_Iterations > this.maxIterations) {
                converged = true;
            }
            this.m_ClusterCentroids = new Instances(instances, this.m_NumClusters);
            for (i = 0; i < this.m_NumClusters; ++i) {
                tempI[i] = new Instances(instances, 0);
            }
            for (i = 0; i < instances.numInstances(); ++i) {
                tempI[clusterAssignments[i]].add(instances.instance(i));
            }
            for (i = 0; i < this.m_NumClusters; ++i) {
                double[] vals = new double[instances.numAttributes()];
                if (tempI[i].numInstances() == 0) {
                    ++emptyClusterCount;
                    continue;
                }
                for (j = 0; j < instances.numAttributes(); ++j) {
                    vals[j] = tempI[i].meanOrMode(j);
                    this.m_ClusterNominalCounts[i][j] = tempI[i].attributeStats((int)j).nominalCounts;
                }
                this.m_ClusterCentroids.add((Instance)new DenseInstance(1.0, vals));
            }
            if (emptyClusterCount > 0) {
                this.m_NumClusters -= emptyClusterCount;
                tempI = new Instances[this.m_NumClusters];
            }
            if (converged) continue;
            this.m_squaredErrors = new double[this.m_NumClusters];
            this.m_ClusterNominalCounts = new int[this.m_NumClusters][instances.numAttributes()][0];
        }
        for (j2 = 0; j2 < this.m_NumClusters; ++j2) {
            this.bucket[j2] = new ArrayList();
        }
        this.m_ClusterStdDevs = new Instances(instances, this.m_NumClusters);
        this.m_ClusterSizes = new int[this.m_NumClusters];
        for (i = 0; i < this.m_NumClusters; ++i) {
            double[] vals2 = new double[instances.numAttributes()];
            for (j = 0; j < instances.numAttributes(); ++j) {
                vals2[j] = instances.attribute(j).isNumeric() ? Math.sqrt(tempI[i].variance(j)) : Utils.missingValue();
            }
            this.m_ClusterStdDevs.add((Instance)new DenseInstance(1.0, vals2));
            this.m_ClusterSizes[i] = tempI[i].numInstances();
        }
    }

    private int clusterProcessedInstance(Instance instance, boolean updateErrors) {
        int bestCluster;
        boolean finished;
        double[] distance = new double[this.m_NumClusters];
        for (int i = 0; i < this.m_NumClusters; ++i) {
            distance[i] = this.distance(instance, this.m_ClusterCentroids.instance(i));
        }
        bucketInstance ci = new bucketInstance();
        ci.setDistances(distance);
        do {
            int j;
            finished = true;
            bestCluster = Utils.minIndex((double[])distance);
            ci.setDistance(distance[bestCluster]);
            for (j = 0; j < this.bucket[bestCluster].size() && ((bucketInstance)this.bucket[bestCluster].get(j)).compareTo(ci) < 0; ++j) {
            }
            this.bucket[bestCluster].add(j, ci);
            if (this.bucket[bestCluster].size() <= this.bucketSize) continue;
            ci = (bucketInstance)this.bucket[bestCluster].remove(this.bucket[bestCluster].size() - 1);
            distance = ci.getDistances();
            distance[bestCluster] = Double.MAX_VALUE;
            ci.setDistances(distance);
            finished = false;
        } while (!finished);
        if (updateErrors) {
            int n = bestCluster;
            this.m_squaredErrors[n] = this.m_squaredErrors[n] + distance[bestCluster];
        }
        return bestCluster;
    }

    public int clusterInstance(Instance instance) throws Exception {
        this.m_ReplaceMissingFilter.input(instance);
        this.m_ReplaceMissingFilter.batchFinished();
        Instance inst = this.m_ReplaceMissingFilter.output();
        return this.clusterProcessedInstance(inst, false);
    }

    private double distance(Instance first, Instance second) {
        double distance = 0.0;
        int p1 = 0;
        int p2 = 0;
        while (p1 < first.numValues() || p2 < second.numValues()) {
            double diff;
            int secondI;
            int firstI = p1 >= first.numValues() ? this.m_ClusterCentroids.numAttributes() : first.index(p1);
            if (firstI == (secondI = p2 >= second.numValues() ? this.m_ClusterCentroids.numAttributes() : second.index(p2))) {
                diff = this.difference(firstI, first.valueSparse(p1), second.valueSparse(p2));
                ++p1;
                ++p2;
            } else if (firstI > secondI) {
                diff = this.difference(secondI, 0.0, second.valueSparse(p2));
                ++p2;
            } else {
                diff = this.difference(firstI, first.valueSparse(p1), 0.0);
                ++p1;
            }
            distance += diff * diff;
        }
        return distance;
    }

    private double difference(int index, double val1, double val2) {
        switch (this.m_ClusterCentroids.attribute(index).type()) {
            case 1: {
                if (Utils.isMissingValue((double)val1) || Utils.isMissingValue((double)val2) || (int)val1 != (int)val2) {
                    return 1.0;
                }
                return 0.0;
            }
            case 0: {
                if (Utils.isMissingValue((double)val1) || Utils.isMissingValue((double)val2)) {
                    if (Utils.isMissingValue((double)val1) && Utils.isMissingValue((double)val2)) {
                        return 1.0;
                    }
                    double diff = Utils.isMissingValue((double)val2) ? this.norm(val1, index) : this.norm(val2, index);
                    if (diff < 0.5) {
                        diff = 1.0 - diff;
                    }
                    return diff;
                }
                return this.norm(val1, index) - this.norm(val2, index);
            }
        }
        return 0.0;
    }

    private double norm(double x, int i) {
        if (Double.isNaN(this.m_Min[i]) || Utils.eq((double)this.m_Max[i], (double)this.m_Min[i])) {
            return 0.0;
        }
        return (x - this.m_Min[i]) / (this.m_Max[i] - this.m_Min[i]);
    }

    private void updateMinMax(Instance instance) {
        for (int j = 0; j < this.m_ClusterCentroids.numAttributes(); ++j) {
            if (instance.isMissing(j)) continue;
            if (Double.isNaN(this.m_Min[j])) {
                this.m_Min[j] = instance.value(j);
                this.m_Max[j] = instance.value(j);
                continue;
            }
            if (instance.value(j) < this.m_Min[j]) {
                this.m_Min[j] = instance.value(j);
                continue;
            }
            if (!(instance.value(j) > this.m_Max[j])) continue;
            this.m_Max[j] = instance.value(j);
        }
    }

    public int numberOfClusters() throws Exception {
        return this.m_NumClusters;
    }

    public Enumeration listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tnumber of clusters.\n\t(default 2).", "N", 1, "-N <num>"));
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement(en.nextElement());
        }
        return result.elements();
    }

    public String numClustersTipText() {
        return "set number of clusters";
    }

    public void setNumClusters(int n) throws Exception {
        if (n <= 0) {
            throw new Exception("Number of clusters must be > 0");
        }
        this.m_NumClusters = n;
        this.bucket = new ArrayList[n];
    }

    public int getNumClusters() {
        return this.m_NumClusters;
    }

    public String toString() {
        int i;
        int maxWidth = 0;
        for (int i2 = 0; i2 < this.m_NumClusters; ++i2) {
            for (int j = 0; j < this.m_ClusterCentroids.numAttributes(); ++j) {
                if (!this.m_ClusterCentroids.attribute(j).isNumeric()) continue;
                double width = Math.log(Math.abs(this.m_ClusterCentroids.instance(i2).value(j))) / Math.log(10.0);
                if ((int)(width += 1.0) <= maxWidth) continue;
                maxWidth = (int)width;
            }
        }
        StringBuilder temp = new StringBuilder();
        String naString = "N/A";
        for (i = 0; i < maxWidth + 2; ++i) {
            naString = naString + " ";
        }
        temp.append("\nkMeans\n======\n");
        temp.append("\nNumber of iterations: ").append(this.m_Iterations).append("\n");
        temp.append("Within cluster sum of squared errors: ").append(Utils.sum((double[])this.m_squaredErrors));
        temp.append("\n\nCluster centroids:\n");
        for (i = 0; i < this.m_NumClusters; ++i) {
            int j;
            temp.append("\nCluster ").append(i).append("\n\t");
            temp.append("Mean/Mode: ");
            for (j = 0; j < this.m_ClusterCentroids.numAttributes(); ++j) {
                if (this.m_ClusterCentroids.attribute(j).isNominal()) {
                    temp.append(" ").append(this.m_ClusterCentroids.attribute(j).value((int)this.m_ClusterCentroids.instance(i).value(j)));
                    continue;
                }
                temp.append(" ").append(Utils.doubleToString((double)this.m_ClusterCentroids.instance(i).value(j), (int)(maxWidth + 5), (int)4));
            }
            temp.append("\n\tStd Devs:  ");
            for (j = 0; j < this.m_ClusterStdDevs.numAttributes(); ++j) {
                if (this.m_ClusterStdDevs.attribute(j).isNumeric()) {
                    temp.append(" ").append(Utils.doubleToString((double)this.m_ClusterStdDevs.instance(i).value(j), (int)(maxWidth + 5), (int)4));
                    continue;
                }
                temp.append(" ").append(naString);
            }
        }
        temp.append("\n\n");
        return temp.toString();
    }

    public Instances getClusterCentroids() {
        return this.m_ClusterCentroids;
    }

    public Instances getClusterStandardDevs() {
        return this.m_ClusterStdDevs;
    }

    public int[][][] getClusterNominalCounts() {
        return this.m_ClusterNominalCounts;
    }

    public double getSquaredError() {
        return Utils.sum((double[])this.m_squaredErrors);
    }

    public int[] getClusterSizes() {
        return this.m_ClusterSizes;
    }

    public static class bucketInstance
    implements Comparable {
        double[] distances;
        double distance;

        public void setDistances(double[] x) {
            this.distances = new double[x.length];
            System.arraycopy(x, 0, this.distances, 0, x.length);
        }

        public void setDistance(double x) {
            this.distance = x;
        }

        public double[] getDistances() {
            return this.distances;
        }

        public double getDistance() {
            return this.distance;
        }

        public int compareTo(Object ci) {
            double d = ((bucketInstance)ci).getDistance();
            if (this.distance - d < 0.0) {
                return -1;
            }
            if (this.distance == d) {
                return 0;
            }
            return 1;
        }
    }
}

