/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier.lazy;

import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import mulan.classifier.MultiLabelOutput;
import mulan.classifier.lazy.MultiLabelKNN;
import mulan.data.MultiLabelInstances;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.TechnicalInformation;
import weka.core.Utils;

public class MLkNN
extends MultiLabelKNN {
    protected double smooth;
    private double[] PriorProbabilities;
    private double[] PriorNProbabilities;
    private double[][] CondProbabilities;
    private double[][] CondNProbabilities;

    public MLkNN(int numOfNeighbors, double smooth) {
        super(numOfNeighbors);
        this.smooth = smooth;
    }

    public MLkNN() {
        this.smooth = 1.0;
    }

    @Override
    public String globalInfo() {
        return "Class implementing the ML-kNN (Multi-Label k Nearest Neighbours) algorithm.\n\nFor more information, see\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Min-Ling Zhang and Zhi-Hua Zhou");
        result.setValue(TechnicalInformation.Field.TITLE, "ML-KNN: A lazy learning approach to multi-label learning");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Pattern Recogn.");
        result.setValue(TechnicalInformation.Field.VOLUME, "40");
        result.setValue(TechnicalInformation.Field.NUMBER, "7");
        result.setValue(TechnicalInformation.Field.YEAR, "2007");
        result.setValue(TechnicalInformation.Field.ISSN, "0031-3203");
        result.setValue(TechnicalInformation.Field.PAGES, "2038--2048");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Elsevier Science Inc.");
        result.setValue(TechnicalInformation.Field.ADDRESS, "New York, NY, USA");
        return result;
    }

    @Override
    protected void buildInternal(MultiLabelInstances train) throws Exception {
        super.buildInternal(train);
        this.PriorProbabilities = new double[this.numLabels];
        this.PriorNProbabilities = new double[this.numLabels];
        this.CondProbabilities = new double[this.numLabels][this.numOfNeighbors + 1];
        this.CondNProbabilities = new double[this.numLabels][this.numOfNeighbors + 1];
        this.ComputePrior();
        this.ComputeCond();
        if (this.getDebug()) {
            int i;
            System.out.println("Computed Prior Probabilities");
            for (i = 0; i < this.numLabels; ++i) {
                System.out.println("Label " + (i + 1) + ": " + this.PriorProbabilities[i]);
            }
            System.out.println("Computed Posterior Probabilities");
            for (i = 0; i < this.numLabels; ++i) {
                System.out.println("Label " + (i + 1));
                for (int j = 0; j < this.numOfNeighbors + 1; ++j) {
                    System.out.println(j + " neighbours: " + this.CondProbabilities[i][j]);
                    System.out.println(j + " neighbours: " + this.CondNProbabilities[i][j]);
                }
            }
        }
    }

    private void ComputePrior() {
        for (int i = 0; i < this.numLabels; ++i) {
            int temp_Ci = 0;
            for (int j = 0; j < this.train.numInstances(); ++j) {
                double value = Double.parseDouble(this.train.attribute(this.labelIndices[i]).value((int)this.train.instance(j).value(this.labelIndices[i])));
                if (!Utils.eq((double)value, (double)1.0)) continue;
                ++temp_Ci;
            }
            this.PriorProbabilities[i] = (this.smooth + (double)temp_Ci) / (this.smooth * 2.0 + (double)this.train.numInstances());
            this.PriorNProbabilities[i] = 1.0 - this.PriorProbabilities[i];
        }
    }

    private void ComputeCond() throws Exception {
        int i;
        int[][] temp_Ci = new int[this.numLabels][this.numOfNeighbors + 1];
        int[][] temp_NCi = new int[this.numLabels][this.numOfNeighbors + 1];
        for (i = 0; i < this.train.numInstances(); ++i) {
            Instances knn = new Instances(this.lnn.kNearestNeighbours(this.train.instance(i), this.numOfNeighbors));
            for (int j = 0; j < this.numLabels; ++j) {
                int aces = 0;
                for (int k = 0; k < this.numOfNeighbors; ++k) {
                    double value = Double.parseDouble(this.train.attribute(this.labelIndices[j]).value((int)knn.instance(k).value(this.labelIndices[j])));
                    if (!Utils.eq((double)value, (double)1.0)) continue;
                    ++aces;
                }
                if (Utils.eq((double)Double.parseDouble(this.train.attribute(this.labelIndices[j]).value((int)this.train.instance(i).value(this.labelIndices[j]))), (double)1.0)) {
                    int[] nArray = temp_Ci[j];
                    int n = aces;
                    nArray[n] = nArray[n] + 1;
                    continue;
                }
                int[] nArray = temp_NCi[j];
                int n = aces;
                nArray[n] = nArray[n] + 1;
            }
        }
        for (i = 0; i < this.numLabels; ++i) {
            int j;
            int temp1 = 0;
            int temp2 = 0;
            for (j = 0; j < this.numOfNeighbors + 1; ++j) {
                temp1 += temp_Ci[i][j];
                temp2 += temp_NCi[i][j];
            }
            for (j = 0; j < this.numOfNeighbors + 1; ++j) {
                this.CondProbabilities[i][j] = (this.smooth + (double)temp_Ci[i][j]) / (this.smooth * (double)(this.numOfNeighbors + 1) + (double)temp1);
                this.CondNProbabilities[i][j] = (this.smooth + (double)temp_NCi[i][j]) / (this.smooth * (double)(this.numOfNeighbors + 1) + (double)temp2);
            }
        }
    }

    @Override
    protected MultiLabelOutput makePredictionInternal(Instance instance) throws Exception {
        double[] confidences = new double[this.numLabels];
        boolean[] predictions = new boolean[this.numLabels];
        Instances knn = null;
        try {
            knn = new Instances(this.lnn.kNearestNeighbours(instance, this.numOfNeighbors));
        }
        catch (Exception ex) {
            Logger.getLogger(MLkNN.class.getName()).log(Level.SEVERE, null, ex);
        }
        for (int i = 0; i < this.numLabels; ++i) {
            Random rnd;
            int aces = 0;
            for (int k = 0; k < this.numOfNeighbors; ++k) {
                double value = Double.parseDouble(this.train.attribute(this.labelIndices[i]).value((int)knn.instance(k).value(this.labelIndices[i])));
                if (!Utils.eq((double)value, (double)1.0)) continue;
                ++aces;
            }
            double Prob_in = this.PriorProbabilities[i] * this.CondProbabilities[i][aces];
            double Prob_out = this.PriorNProbabilities[i] * this.CondNProbabilities[i][aces];
            predictions[i] = Prob_in > Prob_out ? true : (Prob_in < Prob_out ? false : (rnd = new Random()).nextInt(2) == 1);
            confidences[i] = Prob_in / (Prob_in + Prob_out);
        }
        MultiLabelOutput mlo = new MultiLabelOutput(predictions, confidences);
        return mlo;
    }
}

