/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier;

import java.util.Arrays;
import mulan.core.ArgumentNullException;
import weka.core.Utils;

public class MultiLabelOutput {
    private boolean[] bipartition;
    private int[] ranking;
    private double[] confidences;

    public MultiLabelOutput(boolean[] bipartition) {
        if (bipartition == null) {
            throw new ArgumentNullException("bipartitions");
        }
        this.bipartition = Arrays.copyOf(bipartition, bipartition.length);
    }

    public MultiLabelOutput(int[] ranking) {
        if (ranking == null) {
            throw new ArgumentNullException("ranking");
        }
        this.ranking = Arrays.copyOf(ranking, ranking.length);
    }

    public MultiLabelOutput(double[] probabilities, double threshold) {
        if (probabilities == null) {
            throw new ArgumentNullException("probabilities");
        }
        this.confidences = probabilities;
        this.ranking = MultiLabelOutput.ranksFromValues(probabilities);
        this.bipartition = new boolean[probabilities.length];
        for (int i = 0; i < probabilities.length; ++i) {
            if (!(probabilities[i] >= threshold)) continue;
            this.bipartition[i] = true;
        }
    }

    public MultiLabelOutput(double[] probabilities) {
        if (probabilities == null) {
            throw new ArgumentNullException("probabilities");
        }
        this.confidences = probabilities;
        this.ranking = MultiLabelOutput.ranksFromValues(probabilities);
    }

    public MultiLabelOutput(boolean[] bipartition, double[] someConfidences) {
        this(bipartition);
        if (someConfidences == null) {
            throw new ArgumentNullException("someConfidences");
        }
        if (bipartition.length != someConfidences.length) {
            this.bipartition = null;
            throw new IllegalArgumentException("The dimensions of the bipartition  and confidences arrays do not match.");
        }
        this.confidences = Arrays.copyOf(someConfidences, someConfidences.length);
        this.ranking = MultiLabelOutput.ranksFromValues(someConfidences);
    }

    public boolean[] getBipartition() {
        return this.bipartition;
    }

    public boolean hasBipartition() {
        return this.bipartition != null;
    }

    public int[] getRanking() {
        return this.ranking;
    }

    public boolean hasRanking() {
        return this.ranking != null;
    }

    public double[] getConfidences() {
        return this.confidences;
    }

    public boolean hasConfidences() {
        return this.confidences != null;
    }

    public static int[] ranksFromValues(double[] values) {
        int[] temp = Utils.stableSort((double[])values);
        int[] ranks = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            ranks[temp[i]] = values.length - i;
        }
        return ranks;
    }

    public boolean equals(Object mlo) {
        int i;
        if (mlo == this) {
            return true;
        }
        if (!(mlo instanceof MultiLabelOutput)) {
            return false;
        }
        if (this.bipartition == null && ((MultiLabelOutput)mlo).bipartition != null) {
            return false;
        }
        if (this.bipartition != null) {
            if (((MultiLabelOutput)mlo).bipartition == null) {
                return false;
            }
            for (i = 0; i < this.bipartition.length; ++i) {
                if (this.bipartition[i] == ((MultiLabelOutput)mlo).bipartition[i]) continue;
                return false;
            }
        }
        if (this.ranking == null && ((MultiLabelOutput)mlo).ranking != null) {
            return false;
        }
        if (this.ranking != null) {
            if (((MultiLabelOutput)mlo).ranking == null) {
                return false;
            }
            for (i = 0; i < this.ranking.length; ++i) {
                if (this.ranking[i] == ((MultiLabelOutput)mlo).ranking[i]) continue;
                return false;
            }
        }
        if (this.confidences == null && ((MultiLabelOutput)mlo).confidences != null) {
            return false;
        }
        if (this.confidences != null) {
            if (((MultiLabelOutput)mlo).confidences == null) {
                return false;
            }
            double[] conf = ((MultiLabelOutput)mlo).getConfidences();
            for (int i2 = 0; i2 < this.confidences.length; ++i2) {
                if (Utils.eq((double)this.confidences[i2], (double)conf[i2])) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.bipartition != null) {
            sb.append("Bipartion: ");
            sb.append(Arrays.toString(this.bipartition));
            sb.append(" ");
        }
        if (this.confidences != null) {
            sb.append("Confidences: ");
            sb.append(Arrays.toString(this.confidences));
            sb.append(" ");
        }
        if (this.ranking != null) {
            sb.append("Ranking: ");
            sb.append(Arrays.toString(this.ranking));
        }
        return sb.toString();
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Arrays.hashCode(this.bipartition);
        hash = 89 * hash + Arrays.hashCode(this.ranking);
        hash = 89 * hash + Arrays.hashCode(this.confidences);
        return hash;
    }
}

