/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.unitils.core.Module;
import org.unitils.core.TestListener;
import org.unitils.core.UnitilsException;
import org.unitils.core.util.ObjectToInjectHolder;
import org.unitils.inject.annotation.InjectInto;
import org.unitils.inject.annotation.InjectIntoByType;
import org.unitils.inject.annotation.InjectIntoStatic;
import org.unitils.inject.annotation.InjectIntoStaticByType;
import org.unitils.inject.annotation.TestedObject;
import org.unitils.inject.util.InjectionUtils;
import org.unitils.inject.util.PropertyAccess;
import org.unitils.inject.util.Restore;
import org.unitils.inject.util.ValueToRestore;
import org.unitils.util.AnnotationUtils;
import org.unitils.util.ModuleUtils;
import org.unitils.util.PropertyUtils;
import org.unitils.util.ReflectionUtils;

public class InjectModule
implements Module {
    private static Logger logger = LoggerFactory.getLogger(InjectModule.class);
    private static final String PROPKEY_CREATE_TESTEDOBJECTS_IF_NULL_ENABLED = "InjectModule.TestedObject.createIfNull.enabled";
    private Map<Class<? extends Annotation>, Map<String, String>> defaultAnnotationPropertyValues;
    private List<ValueToRestore> valuesToRestoreAfterTest = new ArrayList<ValueToRestore>();
    private boolean createTestedObjectsIfNullEnabled;

    public void init(Properties configuration) {
        this.defaultAnnotationPropertyValues = ModuleUtils.getAnnotationPropertyDefaults(InjectModule.class, (Properties)configuration, (Class[])new Class[]{InjectInto.class, InjectIntoStatic.class, InjectIntoByType.class, InjectIntoStaticByType.class});
        this.createTestedObjectsIfNullEnabled = PropertyUtils.getBoolean((String)PROPKEY_CREATE_TESTEDOBJECTS_IF_NULL_ENABLED, (Properties)configuration);
    }

    public void afterInit() {
    }

    public void createTestedObjectsIfNull(Object testObject) {
        Set testedObjectFields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), TestedObject.class);
        for (Field testedObjectField : testedObjectFields) {
            if (ReflectionUtils.getFieldValue((Object)testObject, (Field)testedObjectField) != null) continue;
            this.createObjectForField(testObject, testedObjectField);
        }
    }

    protected void createObjectForField(Object testObject, Field testedObjectField) {
        Class<?> declaredClass = testedObjectField.getType();
        if (declaredClass.isInterface()) {
            logger.warn("Field " + testedObjectField.getName() + " (annotated with @TestedObject) has type " + testedObjectField.getType().getSimpleName() + " which is an interface type. It is not automatically instantiated.");
        } else if (Modifier.isAbstract(declaredClass.getModifiers())) {
            logger.warn("Field " + testedObjectField.getName() + " (annotated with @TestedObject) has type " + testedObjectField.getDeclaringClass().getSimpleName() + " which is an abstract class. It is not automatically instantiated.");
        } else {
            try {
                declaredClass.getDeclaredConstructor(new Class[0]);
                Object instance = ReflectionUtils.createInstanceOfType(declaredClass, (boolean)true);
                ReflectionUtils.setFieldValue((Object)testObject, (Field)testedObjectField, (Object)instance);
            }
            catch (NoSuchMethodException e) {
                logger.warn("Field " + testedObjectField.getName() + " (annotated with @TestedObject) has type " + testedObjectField.getDeclaringClass().getSimpleName() + " which has no default (parameterless) constructor. It is not automatically instantiated.", (Throwable)e);
            }
        }
    }

    public void injectObjects(Object test) {
        this.injectAll(test);
        this.injectAllByType(test);
        this.injectAllStatic(test);
        this.injectAllStaticByType(test);
    }

    public void injectAll(Object test) {
        Set fields = AnnotationUtils.getFieldsAnnotatedWith(test.getClass(), InjectInto.class);
        for (Field field : fields) {
            this.inject(test, field);
        }
    }

    public void injectAllByType(Object test) {
        Set fields = AnnotationUtils.getFieldsAnnotatedWith(test.getClass(), InjectIntoByType.class);
        for (Field field : fields) {
            this.injectByType(test, field);
        }
    }

    public void injectAllStatic(Object test) {
        Set fields = AnnotationUtils.getFieldsAnnotatedWith(test.getClass(), InjectIntoStatic.class);
        for (Field field : fields) {
            this.injectStatic(test, field);
        }
    }

    public void injectAllStaticByType(Object test) {
        Set fields = AnnotationUtils.getFieldsAnnotatedWith(test.getClass(), InjectIntoStaticByType.class);
        for (Field field : fields) {
            this.injectStaticByType(test, field);
        }
    }

    public void restoreStaticInjectedObjects() {
        for (ValueToRestore valueToRestore : this.valuesToRestoreAfterTest) {
            this.restore(valueToRestore);
        }
    }

    protected void inject(Object test, Field fieldToInject) {
        InjectInto injectIntoAnnotation = fieldToInject.getAnnotation(InjectInto.class);
        String ognlExpression = injectIntoAnnotation.property();
        if (StringUtils.isEmpty((CharSequence)ognlExpression)) {
            throw new UnitilsException(this.getSituatedErrorMessage(InjectInto.class, fieldToInject, "Property cannot be empty"));
        }
        Object objectToInject = this.getObjectToInject(test, fieldToInject);
        List<Object> targets = this.getTargets(InjectInto.class, fieldToInject, injectIntoAnnotation.target(), test);
        if (targets.size() == 0) {
            throw new UnitilsException(this.getSituatedErrorMessage(InjectInto.class, fieldToInject, "The target should either be specified explicitly using the target property, or by using the @" + TestedObject.class.getSimpleName() + " annotation"));
        }
        for (Object target : targets) {
            try {
                InjectionUtils.injectInto(objectToInject, target, ognlExpression);
            }
            catch (UnitilsException e) {
                throw new UnitilsException(this.getSituatedErrorMessage(InjectInto.class, fieldToInject, e.getMessage()), (Throwable)e);
            }
        }
    }

    protected void injectStatic(Object test, Field fieldToInjectStatic) {
        InjectIntoStatic injectIntoStaticAnnotation = fieldToInjectStatic.getAnnotation(InjectIntoStatic.class);
        Class<?>[] targetClass = injectIntoStaticAnnotation.target();
        String property = injectIntoStaticAnnotation.property();
        if (StringUtils.isEmpty((CharSequence)property)) {
            throw new UnitilsException(this.getSituatedErrorMessage(InjectIntoStatic.class, fieldToInjectStatic, "Property cannot be empty"));
        }
        Object objectToInject = this.getObjectToInject(test, fieldToInjectStatic);
        Restore restore = (Restore)ModuleUtils.getEnumValueReplaceDefault(InjectIntoStatic.class, (String)"restore", (Enum)injectIntoStaticAnnotation.restore(), this.defaultAnnotationPropertyValues);
        try {
            for (Class<?> clzz : targetClass) {
                Object oldValue = InjectionUtils.injectIntoStatic(objectToInject, clzz, property);
                this.storeValueToRestoreAfterTest(clzz, property, fieldToInjectStatic.getType(), null, oldValue, restore);
            }
        }
        catch (UnitilsException e) {
            throw new UnitilsException(this.getSituatedErrorMessage(InjectIntoStatic.class, fieldToInjectStatic, e.getMessage()), (Throwable)e);
        }
    }

    protected void injectByType(Object test, Field fieldToInject) {
        InjectIntoByType injectIntoByTypeAnnotation = fieldToInject.getAnnotation(InjectIntoByType.class);
        Object objectToInject = this.getObjectToInject(test, fieldToInject);
        Type objectToInjectType = this.getObjectToInjectType(test, fieldToInject);
        PropertyAccess propertyAccess = (PropertyAccess)ModuleUtils.getEnumValueReplaceDefault(InjectIntoByType.class, (String)"propertyAccess", (Enum)injectIntoByTypeAnnotation.propertyAccess(), this.defaultAnnotationPropertyValues);
        List<Object> targets = this.getTargets(InjectIntoByType.class, fieldToInject, injectIntoByTypeAnnotation.target(), test);
        if (targets.size() == 0) {
            throw new UnitilsException(this.getSituatedErrorMessage(InjectIntoByType.class, fieldToInject, "The target should either be specified explicitly using the target property, or by using the @" + TestedObject.class.getSimpleName() + " annotation"));
        }
        for (Object target : targets) {
            try {
                InjectionUtils.injectIntoByType(objectToInject, objectToInjectType, target, propertyAccess);
            }
            catch (UnitilsException e) {
                throw new UnitilsException(this.getSituatedErrorMessage(InjectIntoByType.class, fieldToInject, e.getMessage()), (Throwable)e);
            }
        }
    }

    protected void injectStaticByType(Object test, Field fieldToAutoInjectStatic) {
        InjectIntoStaticByType injectIntoStaticByTypeAnnotation = fieldToAutoInjectStatic.getAnnotation(InjectIntoStaticByType.class);
        Class<?>[] targetClass = injectIntoStaticByTypeAnnotation.target();
        Object objectToInject = this.getObjectToInject(test, fieldToAutoInjectStatic);
        Type objectToInjectType = this.getObjectToInjectType(test, fieldToAutoInjectStatic);
        Class objectToInjectClass = ReflectionUtils.getClassForType((Type)objectToInjectType);
        Restore restore = (Restore)ModuleUtils.getEnumValueReplaceDefault(InjectIntoStaticByType.class, (String)"restore", (Enum)injectIntoStaticByTypeAnnotation.restore(), this.defaultAnnotationPropertyValues);
        PropertyAccess propertyAccess = (PropertyAccess)ModuleUtils.getEnumValueReplaceDefault(InjectIntoStaticByType.class, (String)"propertyAccess", (Enum)injectIntoStaticByTypeAnnotation.propertyAccess(), this.defaultAnnotationPropertyValues);
        try {
            for (Class<?> clzz : targetClass) {
                Object oldValue = InjectionUtils.injectIntoStaticByType(objectToInject, objectToInjectType, clzz, propertyAccess);
                this.storeValueToRestoreAfterTest(clzz, null, objectToInjectClass, propertyAccess, oldValue, restore);
            }
        }
        catch (UnitilsException e) {
            throw new UnitilsException(this.getSituatedErrorMessage(InjectIntoStaticByType.class, fieldToAutoInjectStatic, e.getMessage()), (Throwable)e);
        }
    }

    protected Object getObjectToInject(Object test, Field fieldToInject) {
        Object fieldValue = ReflectionUtils.getFieldValue((Object)test, (Field)fieldToInject);
        if (fieldValue instanceof ObjectToInjectHolder) {
            return ((ObjectToInjectHolder)fieldValue).getObjectToInject();
        }
        return fieldValue;
    }

    protected Type getObjectToInjectType(Object test, Field fieldToInject) {
        Object fieldValue = ReflectionUtils.getFieldValue((Object)test, (Field)fieldToInject);
        if (fieldValue instanceof ObjectToInjectHolder) {
            return ((ObjectToInjectHolder)fieldValue).getObjectToInjectType(fieldToInject);
        }
        return fieldToInject.getType();
    }

    protected void restore(ValueToRestore valueToRestore) {
        Object value = valueToRestore.getValue();
        Class<?> targetClass = valueToRestore.getTargetClass();
        String property = valueToRestore.getProperty();
        if (property != null) {
            InjectionUtils.injectIntoStatic(value, targetClass, property);
        } else {
            InjectionUtils.injectIntoStaticByType(value, valueToRestore.getFieldType(), targetClass, valueToRestore.getPropertyAccessType());
        }
    }

    protected void storeValueToRestoreAfterTest(Class<?> targetClass, String property, Class<?> fieldType, PropertyAccess propertyAccess, Object oldValue, Restore restore) {
        ValueToRestore valueToRestore;
        if (Restore.NO_RESTORE == restore || Restore.DEFAULT == restore) {
            return;
        }
        if (Restore.OLD_VALUE == restore) {
            valueToRestore = new ValueToRestore(targetClass, property, fieldType, propertyAccess, oldValue);
        } else if (Restore.NULL_OR_0_VALUE == restore) {
            valueToRestore = new ValueToRestore(targetClass, property, fieldType, propertyAccess, fieldType.isPrimitive() ? Integer.valueOf(0) : null);
        } else {
            throw new RuntimeException("Unknown value for " + Restore.class.getSimpleName() + " " + restore);
        }
        this.valuesToRestoreAfterTest.add(valueToRestore);
    }

    protected List<Object> getTargets(Class<? extends Annotation> annotationClass, Field annotatedField, String[] targetNames, Object test) {
        ArrayList<Object> targets = null;
        if (ArrayUtils.isEmpty((Object[])targetNames)) {
            Set testedObjectFields = AnnotationUtils.getFieldsAnnotatedWith(test.getClass(), TestedObject.class);
            targets = new ArrayList(testedObjectFields.size());
            for (Field testedObjectField : testedObjectFields) {
                Object target = this.getTarget(test, testedObjectField);
                targets.add(target);
            }
        } else {
            targets = new ArrayList<Object>(targetNames.length);
            for (String targetName : targetNames) {
                Field field = ReflectionUtils.getFieldWithName(test.getClass(), (String)targetName, (boolean)false);
                if (field == null) {
                    throw new UnitilsException(this.getSituatedErrorMessage(annotationClass, annotatedField, "Target with name " + targetNames + " does not exist"));
                }
                Object target = this.getTarget(test, field);
                targets.add(target);
            }
        }
        return targets;
    }

    protected Object getTarget(Object test, Field field) {
        Object target = ReflectionUtils.getFieldValue((Object)test, (Field)field);
        if (target instanceof ObjectToInjectHolder) {
            target = ((ObjectToInjectHolder)target).getObjectToInject();
        }
        return target;
    }

    protected String getSituatedErrorMessage(Class<? extends Annotation> annotationClass, Field annotatedField, String errorDescription) {
        return "Error while processing @" + annotationClass.getSimpleName() + " annotation on field " + annotatedField.getName() + " of class " + annotatedField.getDeclaringClass().getSimpleName() + ": " + errorDescription;
    }

    public TestListener getTestListener() {
        return new InjectTestListener();
    }

    protected class InjectTestListener
    extends TestListener {
        protected InjectTestListener() {
        }

        public void beforeTestMethod(Object testObject, Method testMethod) {
            if (InjectModule.this.createTestedObjectsIfNullEnabled) {
                InjectModule.this.createTestedObjectsIfNull(testObject);
            }
            InjectModule.this.injectObjects(testObject);
        }

        public void afterTestMethod(Object testObject, Method testMethod, Throwable throwable) {
            InjectModule.this.restoreStaticInjectedObjects();
        }
    }
}

