/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mardao.dao;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Stack;
import java.util.concurrent.Future;
import net.sf.mardao.MappingIterable;
import net.sf.mardao.core.CursorPage;
import net.sf.mardao.core.EntityFuture;
import net.sf.mardao.core.KeyFuture;
import net.sf.mardao.core.filter.Filter;
import net.sf.mardao.dao.Mapper;
import net.sf.mardao.dao.Supplier;
import net.sf.mardao.dao.TransFunc;

public class AbstractDao<T, ID extends Serializable> {
    private static final ThreadLocal<String> principalName = new ThreadLocal();
    private static final ThreadLocal<Stack> TRANSACTION_STACKS = new ThreadLocal();
    private final Mapper<T, ID> mapper;
    private final Supplier supplier;

    protected AbstractDao(Mapper<T, ID> mapper, Supplier supplier) {
        this.mapper = mapper;
        this.supplier = supplier;
    }

    public <R> R withCommitTransaction(TransFunc<R> transFunc) throws IOException {
        return this.withTransaction(transFunc, true);
    }

    public <R> R withRollbackTransaction(TransFunc<R> transFunc) throws IOException {
        return this.withTransaction(transFunc, false);
    }

    public <R> R withTransaction(TransFunc<R> transFunc, boolean commit) throws IOException {
        return AbstractDao.withTransaction(transFunc, commit, this.supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R withTransaction(TransFunc<R> transFunc, boolean commit, Supplier supplier) throws IOException {
        Object transaction = supplier.beginTransaction();
        AbstractDao.pushTransaction(transaction);
        try {
            R result = transFunc.apply();
            if (commit) {
                supplier.commitTransaction(transaction);
            }
            R r = result;
            return r;
        }
        finally {
            AbstractDao.popTransaction(transaction);
            supplier.rollbackActiveTransaction(transaction);
        }
    }

    private static void pushTransaction(Object transaction) {
        Stack<Object> stack = TRANSACTION_STACKS.get();
        if (null == stack) {
            stack = new Stack<Object>();
            TRANSACTION_STACKS.set(stack);
        }
        stack.push(transaction);
    }

    private static void popTransaction(Object transaction) {
        Stack stack = TRANSACTION_STACKS.get();
        Object popped = stack.pop();
        if (popped != transaction) {
            throw new IllegalStateException("Transaction differs.");
        }
    }

    private static Object getCurrentTransaction() {
        Stack stack = TRANSACTION_STACKS.get();
        if (null == stack) {
            return null;
        }
        return stack.isEmpty() ? null : stack.peek();
    }

    public int count() {
        return this.count(null);
    }

    public int count(Object parentKey) {
        return this.supplier.count(AbstractDao.getCurrentTransaction(), this.mapper.getKind(), parentKey, null, new Filter[0]);
    }

    public void delete(ID id) throws IOException {
        this.delete(null, id);
    }

    public void delete(Object parentKey, ID id) throws IOException {
        Object key = this.mapper.toKey(parentKey, id);
        this.supplier.deleteValue(AbstractDao.getCurrentTransaction(), key);
    }

    public void delete(Iterable<ID> ids) throws IOException {
        ArrayList<Object> keys = new ArrayList<Object>();
        for (Serializable id : ids) {
            keys.add(this.mapper.toKey(null, id));
        }
        this.supplier.deleteValues(AbstractDao.getCurrentTransaction(), keys);
    }

    public T get(ID id) throws IOException {
        return this.get(null, id);
    }

    public T get(Object parentKey, ID id) throws IOException {
        Object key = this.mapper.toKey(parentKey, id);
        Object value = this.supplier.readValue(AbstractDao.getCurrentTransaction(), key);
        if (null == value) {
            return null;
        }
        T entity = this.mapper.fromReadValue(value);
        return entity;
    }

    public ID put(T entity) throws IOException {
        ID id = this.mapper.getId(entity);
        Object parentKey = this.mapper.getParentKey(entity);
        Object key = this.mapper.toKey(parentKey, id);
        Object value = this.mapper.toWriteValue(entity);
        this.updateAuditInfo(value);
        key = this.supplier.writeValue(AbstractDao.getCurrentTransaction(), key, value);
        id = this.mapper.fromKey(key);
        this.mapper.updateEntityPostWrite(entity, key, value);
        return id;
    }

    protected Iterable<T> queryByField(Object ancestorKey, String fieldName, Object fieldValue) {
        Iterable values = this.supplier.queryIterable(AbstractDao.getCurrentTransaction(), this.mapper.getKind(), false, 0, -1, ancestorKey, null, null, false, null, false, Filter.equalsFilter(fieldName, fieldValue));
        return new MappingIterable<T, ID>(this.mapper, values.iterator());
    }

    protected T queryUniqueByField(Object parentKey, String fieldName, Object fieldValue) {
        Object value = this.supplier.queryUnique(AbstractDao.getCurrentTransaction(), parentKey, this.mapper.getKind(), Filter.equalsFilter(fieldName, fieldValue));
        if (null == value) {
            return null;
        }
        return this.mapper.fromReadValue(value);
    }

    public CursorPage<T> queryPage(int requestedPageSize, String cursorString) {
        return this.queryPage(false, requestedPageSize, null, null, false, null, false, null, cursorString, new Filter[0]);
    }

    public CursorPage<T> queryPage(Object ancestorKey, int requestedPageSize, String cursorString) {
        return this.queryPage(false, requestedPageSize, ancestorKey, null, false, null, false, null, cursorString, new Filter[0]);
    }

    protected CursorPage<T> queryPage(boolean keysOnly, int requestedPageSize, Object ancestorKey, String primaryOrderBy, boolean primaryIsAscending, String secondaryOrderBy, boolean secondaryIsAscending, Collection<String> projections, String cursorString, Filter ... filters) {
        CursorPage page = this.supplier.queryPage(AbstractDao.getCurrentTransaction(), this.mapper.getKind(), false, requestedPageSize, ancestorKey, primaryOrderBy, primaryIsAscending, secondaryOrderBy, secondaryIsAscending, projections, cursorString, filters);
        ArrayList<T> entities = new ArrayList<T>(page.getItems().size());
        for (Object value : page.getItems()) {
            T entity = this.mapper.fromReadValue(value);
            entities.add(entity);
        }
        page.setItems(entities);
        return page;
    }

    protected Iterable<T> queryIterable(boolean keysOnly, int offset, int limit, Object ancestorKey, String primaryOrderBy, boolean primaryIsAscending, String secondaryOrderBy, boolean secondaryIsAscending, Filter ... filters) {
        final Iterable iterable = this.supplier.queryIterable(AbstractDao.getCurrentTransaction(), this.mapper.getKind(), false, offset, limit, ancestorKey, null, primaryOrderBy, primaryIsAscending, secondaryOrderBy, secondaryIsAscending, filters);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final Iterator wrappedIterator = iterable.iterator();
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return wrappedIterator.hasNext();
                    }

                    @Override
                    public T next() {
                        return AbstractDao.this.mapper.fromReadValue(wrappedIterator.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public Future<T> getAsync(Object parentKey, ID id) throws IOException {
        Object key = this.mapper.toKey(parentKey, id);
        Future future = this.supplier.readFuture(AbstractDao.getCurrentTransaction(), key);
        return new EntityFuture<T>(this.mapper, future);
    }

    public Future<ID> putAsync(T entity) throws IOException {
        ID id = this.mapper.getId(entity);
        Object parentKey = this.mapper.getParentKey(entity);
        Object key = this.mapper.toKey(parentKey, id);
        Object value = this.mapper.toWriteValue(entity);
        this.updateAuditInfo(value);
        Future<Object> future = this.supplier.writeFuture(AbstractDao.getCurrentTransaction(), key, value);
        return new KeyFuture<T, ID>(this.mapper, future, entity, value);
    }

    public ID getId(Object key) {
        return this.mapper.fromKey(key);
    }

    public Object getKey(ID id) {
        return this.getKey(null, id);
    }

    public Object getKey(Object parentKey, ID id) {
        return this.mapper.toKey(parentKey, id);
    }

    public String getKind() {
        return this.mapper.getKind();
    }

    public void setParentKey(T entity, Object parentKey) {
        this.mapper.setParentKey(entity, parentKey);
    }

    public static void setPrincipalName(String name) {
        principalName.set(name);
    }

    private void updateAuditInfo(Object value) {
        this.updateAuditInfo(value, principalName.get(), new Date(), this.mapper.getCreatedByColumnName(), this.mapper.getCreatedDateColumnName(), this.mapper.getUpdatedByColumnName(), this.mapper.getUpdatedDateColumnName());
    }

    protected void updateAuditInfo(Object value, String principalName, Date date, String createdByColumnName, String createdDateColumnName, String updatedByColumnName, String updatedDateColumnName) {
        if (null != createdByColumnName && null == this.supplier.getString(value, createdByColumnName)) {
            this.supplier.setString(value, createdByColumnName, principalName);
        }
        if (null != createdDateColumnName && null == this.supplier.getDate(value, createdDateColumnName)) {
            this.supplier.setDate(value, createdDateColumnName, date);
        }
        if (null != updatedByColumnName && null != principalName) {
            this.supplier.setString(value, updatedByColumnName, principalName);
        }
        if (null != updatedDateColumnName && null != date) {
            this.supplier.setDate(value, updatedDateColumnName, date);
        }
    }
}

